/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.WorldCount;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorldGenerationJobResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, DescribeWorldGenerationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::arn)).setter(DescribeWorldGenerationJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::statusAsString)).setter(DescribeWorldGenerationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::createdAt)).setter(DescribeWorldGenerationJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::failureCodeAsString)).setter(DescribeWorldGenerationJobResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::failureReason)).setter(DescribeWorldGenerationJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::clientRequestToken)).setter(DescribeWorldGenerationJobResponse.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::template)).setter(DescribeWorldGenerationJobResponse.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<WorldCount> WORLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("worldCount").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::worldCount)).setter(DescribeWorldGenerationJobResponse.setter(Builder::worldCount)).constructor(WorldCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldCount").build()}).build();
    private static final SdkField<FinishedWorldsSummary> FINISHED_WORLDS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("finishedWorldsSummary").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::finishedWorldsSummary)).setter(DescribeWorldGenerationJobResponse.setter(Builder::finishedWorldsSummary)).constructor(FinishedWorldsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishedWorldsSummary").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeWorldGenerationJobResponse.getter(DescribeWorldGenerationJobResponse::tags)).setter(DescribeWorldGenerationJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TEMPLATE_FIELD, WORLD_COUNT_FIELD, FINISHED_WORLDS_SUMMARY_FIELD, TAGS_FIELD));
    private final String arn;
    private final String status;
    private final Instant createdAt;
    private final String failureCode;
    private final String failureReason;
    private final String clientRequestToken;
    private final String template;
    private final WorldCount worldCount;
    private final FinishedWorldsSummary finishedWorldsSummary;
    private final Map<String, String> tags;

    private DescribeWorldGenerationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.clientRequestToken = builder.clientRequestToken;
        this.template = builder.template;
        this.worldCount = builder.worldCount;
        this.finishedWorldsSummary = builder.finishedWorldsSummary;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public WorldGenerationJobStatus status() {
        return WorldGenerationJobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public WorldGenerationJobErrorCode failureCode() {
        return WorldGenerationJobErrorCode.fromValue(this.failureCode);
    }

    public String failureCodeAsString() {
        return this.failureCode;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String template() {
        return this.template;
    }

    public WorldCount worldCount() {
        return this.worldCount;
    }

    public FinishedWorldsSummary finishedWorldsSummary() {
        return this.finishedWorldsSummary;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.worldCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedWorldsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorldGenerationJobResponse)) {
            return false;
        }
        DescribeWorldGenerationJobResponse other = (DescribeWorldGenerationJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.worldCount(), other.worldCount()) && Objects.equals(this.finishedWorldsSummary(), other.finishedWorldsSummary()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorldGenerationJobResponse").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("FailureCode", (Object)this.failureCodeAsString()).add("FailureReason", (Object)this.failureReason()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Template", (Object)this.template()).add("WorldCount", (Object)this.worldCount()).add("FinishedWorldsSummary", (Object)this.finishedWorldsSummary()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "worldCount": {
                return Optional.ofNullable(clazz.cast(this.worldCount()));
            }
            case "finishedWorldsSummary": {
                return Optional.ofNullable(clazz.cast(this.finishedWorldsSummary()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorldGenerationJobResponse, T> g) {
        return obj -> g.apply((DescribeWorldGenerationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant createdAt;
        private String failureCode;
        private String failureReason;
        private String clientRequestToken;
        private String template;
        private WorldCount worldCount;
        private FinishedWorldsSummary finishedWorldsSummary;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorldGenerationJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
            this.clientRequestToken(model.clientRequestToken);
            this.template(model.template);
            this.worldCount(model.worldCount);
            this.finishedWorldsSummary(model.finishedWorldsSummary);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(WorldGenerationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getTemplate() {
            return this.template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final WorldCount.Builder getWorldCount() {
            return this.worldCount != null ? this.worldCount.toBuilder() : null;
        }

        @Override
        public final Builder worldCount(WorldCount worldCount) {
            this.worldCount = worldCount;
            return this;
        }

        public final void setWorldCount(WorldCount.BuilderImpl worldCount) {
            this.worldCount = worldCount != null ? worldCount.build() : null;
        }

        public final FinishedWorldsSummary.Builder getFinishedWorldsSummary() {
            return this.finishedWorldsSummary != null ? this.finishedWorldsSummary.toBuilder() : null;
        }

        @Override
        public final Builder finishedWorldsSummary(FinishedWorldsSummary finishedWorldsSummary) {
            this.finishedWorldsSummary = finishedWorldsSummary;
            return this;
        }

        public final void setFinishedWorldsSummary(FinishedWorldsSummary.BuilderImpl finishedWorldsSummary) {
            this.finishedWorldsSummary = finishedWorldsSummary != null ? finishedWorldsSummary.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeWorldGenerationJobResponse build() {
            return new DescribeWorldGenerationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorldGenerationJobResponse> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(WorldGenerationJobStatus var1);

        public Builder createdAt(Instant var1);

        public Builder failureCode(String var1);

        public Builder failureCode(WorldGenerationJobErrorCode var1);

        public Builder failureReason(String var1);

        public Builder clientRequestToken(String var1);

        public Builder template(String var1);

        public Builder worldCount(WorldCount var1);

        default public Builder worldCount(Consumer<WorldCount.Builder> worldCount) {
            return this.worldCount((WorldCount)((WorldCount.Builder)WorldCount.builder().applyMutation(worldCount)).build());
        }

        public Builder finishedWorldsSummary(FinishedWorldsSummary var1);

        default public Builder finishedWorldsSummary(Consumer<FinishedWorldsSummary.Builder> finishedWorldsSummary) {
            return this.finishedWorldsSummary((FinishedWorldsSummary)((FinishedWorldsSummary.Builder)FinishedWorldsSummary.builder().applyMutation(finishedWorldsSummary)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

