/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.WorldSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.WorldSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorldsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListWorldsResponse> {
    private static final SdkField<List<WorldSummary>> WORLD_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("worldSummaries").getter(ListWorldsResponse.getter(ListWorldsResponse::worldSummaries)).setter(ListWorldsResponse.setter(Builder::worldSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorldSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorldsResponse.getter(ListWorldsResponse::nextToken)).setter(ListWorldsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORLD_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorldSummary> worldSummaries;
    private final String nextToken;

    private ListWorldsResponse(BuilderImpl builder) {
        super(builder);
        this.worldSummaries = builder.worldSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasWorldSummaries() {
        return this.worldSummaries != null && !(this.worldSummaries instanceof SdkAutoConstructList);
    }

    public List<WorldSummary> worldSummaries() {
        return this.worldSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.worldSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorldsResponse)) {
            return false;
        }
        ListWorldsResponse other = (ListWorldsResponse)((Object)obj);
        return Objects.equals(this.worldSummaries(), other.worldSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListWorldsResponse").add("WorldSummaries", this.worldSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "worldSummaries": {
                return Optional.ofNullable(clazz.cast(this.worldSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorldsResponse, T> g) {
        return obj -> g.apply((ListWorldsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<WorldSummary> worldSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorldsResponse model) {
            super(model);
            this.worldSummaries(model.worldSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<WorldSummary.Builder> getWorldSummaries() {
            return this.worldSummaries != null ? (Collection)this.worldSummaries.stream().map(WorldSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder worldSummaries(Collection<WorldSummary> worldSummaries) {
            this.worldSummaries = WorldSummariesCopier.copy(worldSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldSummaries(WorldSummary ... worldSummaries) {
            this.worldSummaries(Arrays.asList(worldSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldSummaries(Consumer<WorldSummary.Builder> ... worldSummaries) {
            this.worldSummaries(Stream.of(worldSummaries).map(c -> (WorldSummary)((WorldSummary.Builder)WorldSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorldSummaries(Collection<WorldSummary.BuilderImpl> worldSummaries) {
            this.worldSummaries = WorldSummariesCopier.copyFromBuilder(worldSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWorldsResponse build() {
            return new ListWorldsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorldsResponse> {
        public Builder worldSummaries(Collection<WorldSummary> var1);

        public Builder worldSummaries(WorldSummary ... var1);

        public Builder worldSummaries(Consumer<WorldSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

