/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.Robot;
import software.amazon.awssdk.services.robomaker.model.RobotsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRobotsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListRobotsResponse> {
    private static final SdkField<List<Robot>> ROBOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("robots").getter(ListRobotsResponse.getter(ListRobotsResponse::robots)).setter(ListRobotsResponse.setter(Builder::robots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Robot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRobotsResponse.getter(ListRobotsResponse::nextToken)).setter(ListRobotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROBOTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Robot> robots;
    private final String nextToken;

    private ListRobotsResponse(BuilderImpl builder) {
        super(builder);
        this.robots = builder.robots;
        this.nextToken = builder.nextToken;
    }

    public boolean hasRobots() {
        return this.robots != null && !(this.robots instanceof SdkAutoConstructList);
    }

    public List<Robot> robots() {
        return this.robots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.robots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRobotsResponse)) {
            return false;
        }
        ListRobotsResponse other = (ListRobotsResponse)((Object)obj);
        return Objects.equals(this.robots(), other.robots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRobotsResponse").add("Robots", this.robots()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "robots": {
                return Optional.ofNullable(clazz.cast(this.robots()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRobotsResponse, T> g) {
        return obj -> g.apply((ListRobotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<Robot> robots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRobotsResponse model) {
            super(model);
            this.robots(model.robots);
            this.nextToken(model.nextToken);
        }

        public final Collection<Robot.Builder> getRobots() {
            return this.robots != null ? (Collection)this.robots.stream().map(Robot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robots(Collection<Robot> robots) {
            this.robots = RobotsCopier.copy(robots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robots(Robot ... robots) {
            this.robots(Arrays.asList(robots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robots(Consumer<Robot.Builder> ... robots) {
            this.robots(Stream.of(robots).map(c -> (Robot)((Robot.Builder)Robot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRobots(Collection<Robot.BuilderImpl> robots) {
            this.robots = RobotsCopier.copyFromBuilder(robots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRobotsResponse build() {
            return new ListRobotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRobotsResponse> {
        public Builder robots(Collection<Robot> var1);

        public Builder robots(Robot ... var1);

        public Builder robots(Consumer<Robot.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

