/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.Architecture;
import software.amazon.awssdk.services.robomaker.model.RobotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Robot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Robot> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Robot.getter(Robot::arn)).setter(Robot.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Robot.getter(Robot::name)).setter(Robot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Robot.getter(Robot::fleetArn)).setter(Robot.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Robot.getter(Robot::statusAsString)).setter(Robot.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> GREEN_GRASS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Robot.getter(Robot::greenGrassGroupId)).setter(Robot.setter(Builder::greenGrassGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greenGrassGroupId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Robot.getter(Robot::createdAt)).setter(Robot.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Robot.getter(Robot::architectureAsString)).setter(Robot.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<String> LAST_DEPLOYMENT_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Robot.getter(Robot::lastDeploymentJob)).setter(Robot.setter(Builder::lastDeploymentJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentJob").build()}).build();
    private static final SdkField<Instant> LAST_DEPLOYMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Robot.getter(Robot::lastDeploymentTime)).setter(Robot.setter(Builder::lastDeploymentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, FLEET_ARN_FIELD, STATUS_FIELD, GREEN_GRASS_GROUP_ID_FIELD, CREATED_AT_FIELD, ARCHITECTURE_FIELD, LAST_DEPLOYMENT_JOB_FIELD, LAST_DEPLOYMENT_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String fleetArn;
    private final String status;
    private final String greenGrassGroupId;
    private final Instant createdAt;
    private final String architecture;
    private final String lastDeploymentJob;
    private final Instant lastDeploymentTime;

    private Robot(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.fleetArn = builder.fleetArn;
        this.status = builder.status;
        this.greenGrassGroupId = builder.greenGrassGroupId;
        this.createdAt = builder.createdAt;
        this.architecture = builder.architecture;
        this.lastDeploymentJob = builder.lastDeploymentJob;
        this.lastDeploymentTime = builder.lastDeploymentTime;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String fleetArn() {
        return this.fleetArn;
    }

    public RobotStatus status() {
        return RobotStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String greenGrassGroupId() {
        return this.greenGrassGroupId;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public String architectureAsString() {
        return this.architecture;
    }

    public String lastDeploymentJob() {
        return this.lastDeploymentJob;
    }

    public Instant lastDeploymentTime() {
        return this.lastDeploymentTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.greenGrassGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Robot)) {
            return false;
        }
        Robot other = (Robot)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.greenGrassGroupId(), other.greenGrassGroupId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.architectureAsString(), other.architectureAsString()) && Objects.equals(this.lastDeploymentJob(), other.lastDeploymentJob()) && Objects.equals(this.lastDeploymentTime(), other.lastDeploymentTime());
    }

    public String toString() {
        return ToString.builder((String)"Robot").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("FleetArn", (Object)this.fleetArn()).add("Status", (Object)this.statusAsString()).add("GreenGrassGroupId", (Object)this.greenGrassGroupId()).add("CreatedAt", (Object)this.createdAt()).add("Architecture", (Object)this.architectureAsString()).add("LastDeploymentJob", (Object)this.lastDeploymentJob()).add("LastDeploymentTime", (Object)this.lastDeploymentTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "fleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "greenGrassGroupId": {
                return Optional.ofNullable(clazz.cast(this.greenGrassGroupId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "lastDeploymentJob": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentJob()));
            }
            case "lastDeploymentTime": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Robot, T> g) {
        return obj -> g.apply((Robot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String fleetArn;
        private String status;
        private String greenGrassGroupId;
        private Instant createdAt;
        private String architecture;
        private String lastDeploymentJob;
        private Instant lastDeploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Robot model) {
            this.arn(model.arn);
            this.name(model.name);
            this.fleetArn(model.fleetArn);
            this.status(model.status);
            this.greenGrassGroupId(model.greenGrassGroupId);
            this.createdAt(model.createdAt);
            this.architecture(model.architecture);
            this.lastDeploymentJob(model.lastDeploymentJob);
            this.lastDeploymentTime(model.lastDeploymentTime);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RobotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getGreenGrassGroupId() {
            return this.greenGrassGroupId;
        }

        @Override
        public final Builder greenGrassGroupId(String greenGrassGroupId) {
            this.greenGrassGroupId = greenGrassGroupId;
            return this;
        }

        public final void setGreenGrassGroupId(String greenGrassGroupId) {
            this.greenGrassGroupId = greenGrassGroupId;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getLastDeploymentJob() {
            return this.lastDeploymentJob;
        }

        @Override
        public final Builder lastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
            return this;
        }

        public final void setLastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
        }

        public final Instant getLastDeploymentTime() {
            return this.lastDeploymentTime;
        }

        @Override
        public final Builder lastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
            return this;
        }

        public final void setLastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
        }

        public Robot build() {
            return new Robot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Robot> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder fleetArn(String var1);

        public Builder status(String var1);

        public Builder status(RobotStatus var1);

        public Builder greenGrassGroupId(String var1);

        public Builder createdAt(Instant var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder lastDeploymentJob(String var1);

        public Builder lastDeploymentTime(Instant var1);
    }
}

