/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RobotStatus {
    AVAILABLE("Available"),
    REGISTERED("Registered"),
    PENDING_NEW_DEPLOYMENT("PendingNewDeployment"),
    DEPLOYING("Deploying"),
    FAILED("Failed"),
    IN_SYNC("InSync"),
    NO_RESPONSE("NoResponse"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RobotStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RobotStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RobotStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RobotStatus> knownValues() {
        return Stream.of(RobotStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

