/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SimulationJobErrorCode {
    INTERNAL_SERVICE_ERROR("InternalServiceError"),
    ROBOT_APPLICATION_CRASH("RobotApplicationCrash"),
    SIMULATION_APPLICATION_CRASH("SimulationApplicationCrash"),
    BAD_PERMISSIONS_ROBOT_APPLICATION("BadPermissionsRobotApplication"),
    BAD_PERMISSIONS_SIMULATION_APPLICATION("BadPermissionsSimulationApplication"),
    BAD_PERMISSIONS_S3_OBJECT("BadPermissionsS3Object"),
    BAD_PERMISSIONS_S3_OUTPUT("BadPermissionsS3Output"),
    BAD_PERMISSIONS_CLOUDWATCH_LOGS("BadPermissionsCloudwatchLogs"),
    SUBNET_IP_LIMIT_EXCEEDED("SubnetIpLimitExceeded"),
    ENI_LIMIT_EXCEEDED("ENILimitExceeded"),
    BAD_PERMISSIONS_USER_CREDENTIALS("BadPermissionsUserCredentials"),
    INVALID_BUNDLE_ROBOT_APPLICATION("InvalidBundleRobotApplication"),
    INVALID_BUNDLE_SIMULATION_APPLICATION("InvalidBundleSimulationApplication"),
    INVALID_S3_RESOURCE("InvalidS3Resource"),
    MISMATCHED_ETAG("MismatchedEtag"),
    ROBOT_APPLICATION_VERSION_MISMATCHED_ETAG("RobotApplicationVersionMismatchedEtag"),
    SIMULATION_APPLICATION_VERSION_MISMATCHED_ETAG("SimulationApplicationVersionMismatchedEtag"),
    RESOURCE_NOT_FOUND("ResourceNotFound"),
    INVALID_INPUT("InvalidInput"),
    WRONG_REGION_S3_BUCKET("WrongRegionS3Bucket"),
    WRONG_REGION_S3_OUTPUT("WrongRegionS3Output"),
    WRONG_REGION_ROBOT_APPLICATION("WrongRegionRobotApplication"),
    WRONG_REGION_SIMULATION_APPLICATION("WrongRegionSimulationApplication"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SimulationJobErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SimulationJobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SimulationJobErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SimulationJobErrorCode> knownValues() {
        return Stream.of(SimulationJobErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

