/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api.internal.backoff;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class FixedDelayWithoutJitter
implements BackoffStrategy {
    private final Duration delay;

    public FixedDelayWithoutJitter(Duration delay) {
        this.delay = Validate.isPositive((Duration)delay, (String)"delay");
    }

    @Override
    public Duration computeDelay(int attempt) {
        Validate.isPositive((int)attempt, (String)"attempt");
        return this.delay;
    }

    public String toString() {
        return ToString.builder((String)"FixedDelayWithoutJitter").add("delay", (Object)this.delay).build();
    }
}

