/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.services.resourcegroups.model.TagSyncTaskItem;
import software.amazon.awssdk.services.resourcegroups.model.TagSyncTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagSyncTasksResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, ListTagSyncTasksResponse> {
    private static final SdkField<List<TagSyncTaskItem>> TAG_SYNC_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSyncTasks").getter(ListTagSyncTasksResponse.getter(ListTagSyncTasksResponse::tagSyncTasks)).setter(ListTagSyncTasksResponse.setter(Builder::tagSyncTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSyncTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSyncTaskItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTagSyncTasksResponse.getter(ListTagSyncTasksResponse::nextToken)).setter(ListTagSyncTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SYNC_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTagSyncTasksResponse.memberNameToFieldInitializer();
    private final List<TagSyncTaskItem> tagSyncTasks;
    private final String nextToken;

    private ListTagSyncTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tagSyncTasks = builder.tagSyncTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTagSyncTasks() {
        return this.tagSyncTasks != null && !(this.tagSyncTasks instanceof SdkAutoConstructList);
    }

    public final List<TagSyncTaskItem> tagSyncTasks() {
        return this.tagSyncTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSyncTasks() ? this.tagSyncTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagSyncTasksResponse)) {
            return false;
        }
        ListTagSyncTasksResponse other = (ListTagSyncTasksResponse)((Object)obj);
        return this.hasTagSyncTasks() == other.hasTagSyncTasks() && Objects.equals(this.tagSyncTasks(), other.tagSyncTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagSyncTasksResponse").add("TagSyncTasks", this.hasTagSyncTasks() ? this.tagSyncTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagSyncTasks": {
                return Optional.ofNullable(clazz.cast(this.tagSyncTasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TagSyncTasks", TAG_SYNC_TASKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTagSyncTasksResponse, T> g) {
        return obj -> g.apply((ListTagSyncTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private List<TagSyncTaskItem> tagSyncTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagSyncTasksResponse model) {
            super(model);
            this.tagSyncTasks(model.tagSyncTasks);
            this.nextToken(model.nextToken);
        }

        public final List<TagSyncTaskItem.Builder> getTagSyncTasks() {
            List<TagSyncTaskItem.Builder> result = TagSyncTaskListCopier.copyToBuilder(this.tagSyncTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSyncTasks(Collection<TagSyncTaskItem.BuilderImpl> tagSyncTasks) {
            this.tagSyncTasks = TagSyncTaskListCopier.copyFromBuilder(tagSyncTasks);
        }

        @Override
        public final Builder tagSyncTasks(Collection<TagSyncTaskItem> tagSyncTasks) {
            this.tagSyncTasks = TagSyncTaskListCopier.copy(tagSyncTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSyncTasks(TagSyncTaskItem ... tagSyncTasks) {
            this.tagSyncTasks(Arrays.asList(tagSyncTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSyncTasks(Consumer<TagSyncTaskItem.Builder> ... tagSyncTasks) {
            this.tagSyncTasks(Stream.of(tagSyncTasks).map(c -> (TagSyncTaskItem)((TagSyncTaskItem.Builder)TagSyncTaskItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTagSyncTasksResponse build() {
            return new ListTagSyncTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagSyncTasksResponse> {
        public Builder tagSyncTasks(Collection<TagSyncTaskItem> var1);

        public Builder tagSyncTasks(TagSyncTaskItem ... var1);

        public Builder tagSyncTasks(Consumer<TagSyncTaskItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

