/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationParameter;
import software.amazon.awssdk.services.resourcegroups.model.GroupParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupConfigurationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupConfigurationItem> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GroupConfigurationItem.getter(GroupConfigurationItem::type)).setter(GroupConfigurationItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<GroupConfigurationParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(GroupConfigurationItem.getter(GroupConfigurationItem::parameters)).setter(GroupConfigurationItem.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupConfigurationParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupConfigurationItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<GroupConfigurationParameter> parameters;

    private GroupConfigurationItem(BuilderImpl builder) {
        this.type = builder.type;
        this.parameters = builder.parameters;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<GroupConfigurationParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupConfigurationItem)) {
            return false;
        }
        GroupConfigurationItem other = (GroupConfigurationItem)obj;
        return Objects.equals(this.type(), other.type()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"GroupConfigurationItem").add("Type", (Object)this.type()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupConfigurationItem, T> g) {
        return obj -> g.apply((GroupConfigurationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<GroupConfigurationParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupConfigurationItem model) {
            this.type(model.type);
            this.parameters(model.parameters);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<GroupConfigurationParameter.Builder> getParameters() {
            List<GroupConfigurationParameter.Builder> result = GroupParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<GroupConfigurationParameter.BuilderImpl> parameters) {
            this.parameters = GroupParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<GroupConfigurationParameter> parameters) {
            this.parameters = GroupParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(GroupConfigurationParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<GroupConfigurationParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (GroupConfigurationParameter)((GroupConfigurationParameter.Builder)GroupConfigurationParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GroupConfigurationItem build() {
            return new GroupConfigurationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupConfigurationItem> {
        public Builder type(String var1);

        public Builder parameters(Collection<GroupConfigurationParameter> var1);

        public Builder parameters(GroupConfigurationParameter ... var1);

        public Builder parameters(Consumer<GroupConfigurationParameter.Builder> ... var1);
    }
}

