/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryErrorCode {
    CLOUDFORMATION_STACK_INACTIVE("CLOUDFORMATION_STACK_INACTIVE"),
    CLOUDFORMATION_STACK_NOT_EXISTING("CLOUDFORMATION_STACK_NOT_EXISTING"),
    CLOUDFORMATION_STACK_UNASSUMABLE_ROLE("CLOUDFORMATION_STACK_UNASSUMABLE_ROLE"),
    RESOURCE_TYPE_NOT_SUPPORTED("RESOURCE_TYPE_NOT_SUPPORTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryErrorCode> VALUE_MAP;
    private final String value;

    private QueryErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryErrorCode> knownValues() {
        EnumSet<QueryErrorCode> knownValues = EnumSet.allOf(QueryErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryErrorCode.class, QueryErrorCode::toString);
    }
}

