/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsClient;
import software.amazon.awssdk.services.resourcegroups.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesItem;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupingStatusesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupingStatusesResponse;

public class ListGroupingStatusesIterable
implements SdkIterable<ListGroupingStatusesResponse> {
    private final ResourceGroupsClient client;
    private final ListGroupingStatusesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupingStatusesIterable(ResourceGroupsClient client, ListGroupingStatusesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGroupingStatusesResponseFetcher();
    }

    public Iterator<ListGroupingStatusesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupingStatusesItem> groupingStatuses() {
        Function<ListGroupingStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupingStatuses() != null) {
                return response.groupingStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupingStatusesResponseFetcher
    implements SyncPageFetcher<ListGroupingStatusesResponse> {
        private ListGroupingStatusesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupingStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupingStatusesResponse nextPage(ListGroupingStatusesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupingStatusesIterable.this.client.listGroupingStatuses(ListGroupingStatusesIterable.this.firstRequest);
            }
            return ListGroupingStatusesIterable.this.client.listGroupingStatuses((ListGroupingStatusesRequest)((Object)ListGroupingStatusesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

