/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGroupRequest
extends ResourceGroupsRequest
implements ToCopyableBuilder<Builder, UpdateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(UpdateGroupRequest.getter(UpdateGroupRequest::groupName)).setter(UpdateGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(UpdateGroupRequest.getter(UpdateGroupRequest::group)).setter(UpdateGroupRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateGroupRequest.getter(UpdateGroupRequest::description)).setter(UpdateGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Criticality").getter(UpdateGroupRequest.getter(UpdateGroupRequest::criticality)).setter(UpdateGroupRequest.setter(Builder::criticality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(UpdateGroupRequest.getter(UpdateGroupRequest::owner)).setter(UpdateGroupRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateGroupRequest.getter(UpdateGroupRequest::displayName)).setter(UpdateGroupRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_FIELD, DESCRIPTION_FIELD, CRITICALITY_FIELD, OWNER_FIELD, DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGroupRequest.memberNameToFieldInitializer();
    private final String groupName;
    private final String group;
    private final String description;
    private final Integer criticality;
    private final String owner;
    private final String displayName;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.group = builder.group;
        this.description = builder.description;
        this.criticality = builder.criticality;
        this.owner = builder.owner;
        this.displayName = builder.displayName;
    }

    @Deprecated
    public final String groupName() {
        return this.groupName;
    }

    public final String group() {
        return this.group;
    }

    public final String description() {
        return this.description;
    }

    public final Integer criticality() {
        return this.criticality;
    }

    public final String owner() {
        return this.owner;
    }

    public final String displayName() {
        return this.displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.criticality());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.criticality(), other.criticality()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGroupRequest").add("GroupName", (Object)this.groupName()).add("Group", (Object)this.group()).add("Description", (Object)this.description()).add("Criticality", (Object)this.criticality()).add("Owner", (Object)this.owner()).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Criticality": {
                return Optional.ofNullable(clazz.cast(this.criticality()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("Group", GROUP_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupRequest, T> g) {
        return obj -> g.apply((UpdateGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private String group;
        private String description;
        private Integer criticality;
        private String owner;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.group(model.group);
            this.description(model.description);
            this.criticality(model.criticality);
            this.owner(model.owner);
            this.displayName(model.displayName);
        }

        @Deprecated
        public final String getGroupName() {
            return this.groupName;
        }

        @Deprecated
        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Deprecated
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getCriticality() {
            return this.criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResourceGroupsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGroupRequest> {
        @Deprecated
        public Builder groupName(String var1);

        public Builder group(String var1);

        public Builder description(String var1);

        public Builder criticality(Integer var1);

        public Builder owner(String var1);

        public Builder displayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

