/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsClient;
import software.amazon.awssdk.services.resourcegroups.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroups.model.ListTagSyncTasksRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListTagSyncTasksResponse;
import software.amazon.awssdk.services.resourcegroups.model.TagSyncTaskItem;

public class ListTagSyncTasksIterable
implements SdkIterable<ListTagSyncTasksResponse> {
    private final ResourceGroupsClient client;
    private final ListTagSyncTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagSyncTasksIterable(ResourceGroupsClient client, ListTagSyncTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTagSyncTasksResponseFetcher();
    }

    public Iterator<ListTagSyncTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TagSyncTaskItem> tagSyncTasks() {
        Function<ListTagSyncTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tagSyncTasks() != null) {
                return response.tagSyncTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTagSyncTasksResponseFetcher
    implements SyncPageFetcher<ListTagSyncTasksResponse> {
        private ListTagSyncTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTagSyncTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTagSyncTasksResponse nextPage(ListTagSyncTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTagSyncTasksIterable.this.client.listTagSyncTasks(ListTagSyncTasksIterable.this.firstRequest);
            }
            return ListTagSyncTasksIterable.this.client.listTagSyncTasks((ListTagSyncTasksRequest)((Object)ListTagSyncTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

