/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupingStatusesFilter;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupingStatusesFilterListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupingStatusesRequest
extends ResourceGroupsRequest
implements ToCopyableBuilder<Builder, ListGroupingStatusesRequest> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(ListGroupingStatusesRequest.getter(ListGroupingStatusesRequest::group)).setter(ListGroupingStatusesRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListGroupingStatusesRequest.getter(ListGroupingStatusesRequest::maxResults)).setter(ListGroupingStatusesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<ListGroupingStatusesFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(ListGroupingStatusesRequest.getter(ListGroupingStatusesRequest::filters)).setter(ListGroupingStatusesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListGroupingStatusesFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupingStatusesRequest.getter(ListGroupingStatusesRequest::nextToken)).setter(ListGroupingStatusesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private final String group;
    private final Integer maxResults;
    private final List<ListGroupingStatusesFilter> filters;
    private final String nextToken;

    private ListGroupingStatusesRequest(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    public final String group() {
        return this.group;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<ListGroupingStatusesFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupingStatusesRequest)) {
            return false;
        }
        ListGroupingStatusesRequest other = (ListGroupingStatusesRequest)((Object)obj);
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupingStatusesRequest").add("Group", (Object)this.group()).add("MaxResults", (Object)this.maxResults()).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupingStatusesRequest, T> g) {
        return obj -> g.apply((ListGroupingStatusesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsRequest.BuilderImpl
    implements Builder {
        private String group;
        private Integer maxResults;
        private List<ListGroupingStatusesFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupingStatusesRequest model) {
            super(model);
            this.group(model.group);
            this.maxResults(model.maxResults);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<ListGroupingStatusesFilter.Builder> getFilters() {
            List<ListGroupingStatusesFilter.Builder> result = ListGroupingStatusesFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ListGroupingStatusesFilter.BuilderImpl> filters) {
            this.filters = ListGroupingStatusesFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ListGroupingStatusesFilter> filters) {
            this.filters = ListGroupingStatusesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ListGroupingStatusesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ListGroupingStatusesFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ListGroupingStatusesFilter)((ListGroupingStatusesFilter.Builder)ListGroupingStatusesFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupingStatusesRequest build() {
            return new ListGroupingStatusesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupingStatusesRequest> {
        public Builder group(String var1);

        public Builder maxResults(Integer var1);

        public Builder filters(Collection<ListGroupingStatusesFilter> var1);

        public Builder filters(ListGroupingStatusesFilter ... var1);

        public Builder filters(Consumer<ListGroupingStatusesFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

