/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.FailedResource;
import software.amazon.awssdk.services.resourcegroups.model.FailedResourceListCopier;
import software.amazon.awssdk.services.resourcegroups.model.PendingResource;
import software.amazon.awssdk.services.resourcegroups.model.PendingResourceListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceArnListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupResourcesResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, GroupResourcesResponse> {
    private static final SdkField<List<String>> SUCCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Succeeded").getter(GroupResourcesResponse.getter(GroupResourcesResponse::succeeded)).setter(GroupResourcesResponse.setter(Builder::succeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedResource>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(GroupResourcesResponse.getter(GroupResourcesResponse::failed)).setter(GroupResourcesResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PendingResource>> PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pending").getter(GroupResourcesResponse.getter(GroupResourcesResponse::pending)).setter(GroupResourcesResponse.setter(Builder::pending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pending").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCEEDED_FIELD, FAILED_FIELD, PENDING_FIELD));
    private final List<String> succeeded;
    private final List<FailedResource> failed;
    private final List<PendingResource> pending;

    private GroupResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.pending = builder.pending;
    }

    public final boolean hasSucceeded() {
        return this.succeeded != null && !(this.succeeded instanceof SdkAutoConstructList);
    }

    public final List<String> succeeded() {
        return this.succeeded;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<FailedResource> failed() {
        return this.failed;
    }

    public final boolean hasPending() {
        return this.pending != null && !(this.pending instanceof SdkAutoConstructList);
    }

    public final List<PendingResource> pending() {
        return this.pending;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSucceeded() ? this.succeeded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPending() ? this.pending() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupResourcesResponse)) {
            return false;
        }
        GroupResourcesResponse other = (GroupResourcesResponse)((Object)obj);
        return this.hasSucceeded() == other.hasSucceeded() && Objects.equals(this.succeeded(), other.succeeded()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed()) && this.hasPending() == other.hasPending() && Objects.equals(this.pending(), other.pending());
    }

    public final String toString() {
        return ToString.builder((String)"GroupResourcesResponse").add("Succeeded", this.hasSucceeded() ? this.succeeded() : null).add("Failed", this.hasFailed() ? this.failed() : null).add("Pending", this.hasPending() ? this.pending() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Succeeded": {
                return Optional.ofNullable(clazz.cast(this.succeeded()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupResourcesResponse, T> g) {
        return obj -> g.apply((GroupResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private List<String> succeeded = DefaultSdkAutoConstructList.getInstance();
        private List<FailedResource> failed = DefaultSdkAutoConstructList.getInstance();
        private List<PendingResource> pending = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupResourcesResponse model) {
            super(model);
            this.succeeded(model.succeeded);
            this.failed(model.failed);
            this.pending(model.pending);
        }

        public final Collection<String> getSucceeded() {
            if (this.succeeded instanceof SdkAutoConstructList) {
                return null;
            }
            return this.succeeded;
        }

        public final void setSucceeded(Collection<String> succeeded) {
            this.succeeded = ResourceArnListCopier.copy(succeeded);
        }

        @Override
        public final Builder succeeded(Collection<String> succeeded) {
            this.succeeded = ResourceArnListCopier.copy(succeeded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeeded(String ... succeeded) {
            this.succeeded(Arrays.asList(succeeded));
            return this;
        }

        public final List<FailedResource.Builder> getFailed() {
            List<FailedResource.Builder> result = FailedResourceListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<FailedResource.BuilderImpl> failed) {
            this.failed = FailedResourceListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<FailedResource> failed) {
            this.failed = FailedResourceListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(FailedResource ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<FailedResource.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (FailedResource)((FailedResource.Builder)FailedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PendingResource.Builder> getPending() {
            List<PendingResource.Builder> result = PendingResourceListCopier.copyToBuilder(this.pending);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPending(Collection<PendingResource.BuilderImpl> pending) {
            this.pending = PendingResourceListCopier.copyFromBuilder(pending);
        }

        @Override
        public final Builder pending(Collection<PendingResource> pending) {
            this.pending = PendingResourceListCopier.copy(pending);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pending(PendingResource ... pending) {
            this.pending(Arrays.asList(pending));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pending(Consumer<PendingResource.Builder> ... pending) {
            this.pending(Stream.of(pending).map(c -> (PendingResource)((PendingResource.Builder)PendingResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GroupResourcesResponse build() {
            return new GroupResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GroupResourcesResponse> {
        public Builder succeeded(Collection<String> var1);

        public Builder succeeded(String ... var1);

        public Builder failed(Collection<FailedResource> var1);

        public Builder failed(FailedResource ... var1);

        public Builder failed(Consumer<FailedResource.Builder> ... var1);

        public Builder pending(Collection<PendingResource> var1);

        public Builder pending(PendingResource ... var1);

        public Builder pending(Consumer<PendingResource.Builder> ... var1);
    }
}

