/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroups.model.GroupIdentifier;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse;

public class ListGroupsPublisher
implements SdkPublisher<ListGroupsResponse> {
    private final ResourceGroupsAsyncClient client;
    private final ListGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupsPublisher(ResourceGroupsAsyncClient client, ListGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupsPublisher(ResourceGroupsAsyncClient client, ListGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupIdentifier> groupIdentifiers() {
        Function<ListGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupIdentifiers() != null) {
                return response.groupIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupsResponseFetcher
    implements AsyncPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupsResponse> nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsPublisher.this.client.listGroups(ListGroupsPublisher.this.firstRequest);
            }
            return ListGroupsPublisher.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

