/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.QueryError;
import software.amazon.awssdk.services.resourcegroups.model.QueryErrorListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchResourcesResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, SearchResourcesResponse> {
    private static final SdkField<List<ResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchResourcesResponse.getter(SearchResourcesResponse::resourceIdentifiers)).setter(SearchResourcesResponse.setter(Builder::resourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchResourcesResponse.getter(SearchResourcesResponse::nextToken)).setter(SearchResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<QueryError>> QUERY_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchResourcesResponse.getter(SearchResourcesResponse::queryErrors)).setter(SearchResourcesResponse.setter(Builder::queryErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD, QUERY_ERRORS_FIELD));
    private final List<ResourceIdentifier> resourceIdentifiers;
    private final String nextToken;
    private final List<QueryError> queryErrors;

    private SearchResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
        this.queryErrors = builder.queryErrors;
    }

    public List<ResourceIdentifier> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<QueryError> queryErrors() {
        return this.queryErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesResponse)) {
            return false;
        }
        SearchResourcesResponse other = (SearchResourcesResponse)((Object)obj);
        return Objects.equals(this.resourceIdentifiers(), other.resourceIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.queryErrors(), other.queryErrors());
    }

    public String toString() {
        return ToString.builder((String)"SearchResourcesResponse").add("ResourceIdentifiers", this.resourceIdentifiers()).add("NextToken", (Object)this.nextToken()).add("QueryErrors", this.queryErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QueryErrors": {
                return Optional.ofNullable(clazz.cast(this.queryErrors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesResponse, T> g) {
        return obj -> g.apply((SearchResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private List<ResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<QueryError> queryErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesResponse model) {
            super(model);
            this.resourceIdentifiers(model.resourceIdentifiers);
            this.nextToken(model.nextToken);
            this.queryErrors(model.queryErrors);
        }

        public final Collection<ResourceIdentifier.Builder> getResourceIdentifiers() {
            return this.resourceIdentifiers != null ? (Collection)this.resourceIdentifiers.stream().map(ResourceIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(ResourceIdentifier ... resourceIdentifiers) {
            this.resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder> ... resourceIdentifiers) {
            this.resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> (ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceIdentifiers(Collection<ResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<QueryError.Builder> getQueryErrors() {
            return this.queryErrors != null ? (Collection)this.queryErrors.stream().map(QueryError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queryErrors(Collection<QueryError> queryErrors) {
            this.queryErrors = QueryErrorListCopier.copy(queryErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryErrors(QueryError ... queryErrors) {
            this.queryErrors(Arrays.asList(queryErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryErrors(Consumer<QueryError.Builder> ... queryErrors) {
            this.queryErrors(Stream.of(queryErrors).map(c -> (QueryError)((QueryError.Builder)QueryError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueryErrors(Collection<QueryError.BuilderImpl> queryErrors) {
            this.queryErrors = QueryErrorListCopier.copyFromBuilder(queryErrors);
        }

        @Override
        public SearchResourcesResponse build() {
            return new SearchResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchResourcesResponse> {
        public Builder resourceIdentifiers(Collection<ResourceIdentifier> var1);

        public Builder resourceIdentifiers(ResourceIdentifier ... var1);

        public Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder queryErrors(Collection<QueryError> var1);

        public Builder queryErrors(QueryError ... var1);

        public Builder queryErrors(Consumer<QueryError.Builder> ... var1);
    }
}

