/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetResourceExplorerSetupResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.RegionStatus;

public class GetResourceExplorerSetupPublisher
implements SdkPublisher<GetResourceExplorerSetupResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final GetResourceExplorerSetupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourceExplorerSetupPublisher(ResourceExplorer2AsyncClient client, GetResourceExplorerSetupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourceExplorerSetupPublisher(ResourceExplorer2AsyncClient client, GetResourceExplorerSetupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourceExplorerSetupResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourceExplorerSetupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegionStatus> regions() {
        Function<GetResourceExplorerSetupResponse, Iterator> getIterator = response -> {
            if (response != null && response.regions() != null) {
                return response.regions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourceExplorerSetupResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourceExplorerSetupResponseFetcher
    implements AsyncPageFetcher<GetResourceExplorerSetupResponse> {
        private GetResourceExplorerSetupResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceExplorerSetupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourceExplorerSetupResponse> nextPage(GetResourceExplorerSetupResponse previousPage) {
            if (previousPage == null) {
                return GetResourceExplorerSetupPublisher.this.client.getResourceExplorerSetup(GetResourceExplorerSetupPublisher.this.firstRequest);
            }
            return GetResourceExplorerSetupPublisher.this.client.getResourceExplorerSetup((GetResourceExplorerSetupRequest)((Object)GetResourceExplorerSetupPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

