/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIndexTypeResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<UpdateIndexTypeResponse.Builder, UpdateIndexTypeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateIndexTypeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateIndexTypeResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateIndexTypeResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(UpdateIndexTypeResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD,
            STATE_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String type;

    private final String state;

    private final Instant lastUpdatedAt;

    private UpdateIndexTypeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.type = builder.type;
        this.state = builder.state;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of the index that you updated.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of the index that you updated.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the type of the specified index after the operation completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of the specified index after the operation completes.
     * @see IndexType
     */
    public final IndexType type() {
        return IndexType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of the specified index after the operation completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of the specified index after the operation completes.
     * @see IndexType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Indicates the state of the request to update the index. This operation is asynchronous. Call the <a>GetIndex</a>
     * operation to check for changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IndexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the state of the request to update the index. This operation is asynchronous. Call the
     *         <a>GetIndex</a> operation to check for changes.
     * @see IndexState
     */
    public final IndexState state() {
        return IndexState.fromValue(state);
    }

    /**
     * <p>
     * Indicates the state of the request to update the index. This operation is asynchronous. Call the <a>GetIndex</a>
     * operation to check for changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IndexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the state of the request to update the index. This operation is asynchronous. Call the
     *         <a>GetIndex</a> operation to check for changes.
     * @see IndexState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and timestamp when the index was last updated.
     * </p>
     * 
     * @return The date and timestamp when the index was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexTypeResponse)) {
            return false;
        }
        UpdateIndexTypeResponse other = (UpdateIndexTypeResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIndexTypeResponse").add("Arn", arn()).add("Type", typeAsString())
                .add("State", stateAsString()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexTypeResponse, T> g) {
        return obj -> g.apply((UpdateIndexTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIndexTypeResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of the index that you updated.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of the index that you updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the type of the specified index after the operation completes.
         * </p>
         * 
         * @param type
         *        Specifies the type of the specified index after the operation completes.
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of the specified index after the operation completes.
         * </p>
         * 
         * @param type
         *        Specifies the type of the specified index after the operation completes.
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(IndexType type);

        /**
         * <p>
         * Indicates the state of the request to update the index. This operation is asynchronous. Call the
         * <a>GetIndex</a> operation to check for changes.
         * </p>
         * 
         * @param state
         *        Indicates the state of the request to update the index. This operation is asynchronous. Call the
         *        <a>GetIndex</a> operation to check for changes.
         * @see IndexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexState
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates the state of the request to update the index. This operation is asynchronous. Call the
         * <a>GetIndex</a> operation to check for changes.
         * </p>
         * 
         * @param state
         *        Indicates the state of the request to update the index. This operation is asynchronous. Call the
         *        <a>GetIndex</a> operation to check for changes.
         * @see IndexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexState
         */
        Builder state(IndexState state);

        /**
         * <p>
         * The date and timestamp when the index was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and timestamp when the index was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String state;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexTypeResponse model) {
            super(model);
            arn(model.arn);
            type(model.type);
            state(model.state);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IndexType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IndexState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public UpdateIndexTypeResponse build() {
            return new UpdateIndexTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
