/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRequest extends ResourceExplorer2Request implements
        ToCopyableBuilder<SearchRequest.Builder, SearchRequest> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(SearchRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewArn").getter(getter(SearchRequest::viewArn)).setter(setter(Builder::viewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD,
            MAX_RESULTS_FIELD, VIEW_ARN_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryString;

    private final Integer maxResults;

    private final String viewArn;

    private final String nextToken;

    private SearchRequest(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.maxResults = builder.maxResults;
        this.viewArn = builder.viewArn;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A string that includes keywords and filters that specify the resources that you want to include in the results.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * The search is completely case insensitive. You can specify an empty string to return all results up to the limit
     * of 1,000 total results.
     * </p>
     * <note>
     * <p>
     * The operation can return only the first 1,000 results. If the resource you want is not included, then use a
     * different value for <code>QueryString</code> to refine the results.
     * </p>
     * </note>
     * 
     * @return A string that includes keywords and filters that specify the resources that you want to include in the
     *         results.</p>
     *         <p>
     *         For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html"
     *         >Search query syntax reference for Resource Explorer</a>.
     *         </p>
     *         <p>
     *         The search is completely case insensitive. You can specify an empty string to return all results up to
     *         the limit of 1,000 total results.
     *         </p>
     *         <note>
     *         <p>
     *         The operation can return only the first 1,000 results. If the resource you want is not included, then use
     *         a different value for <code>QueryString</code> to refine the results.
     *         </p>
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The maximum number of results that you want included on each page of the response. If you do not include this
     * parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included
     * in the current response, the <code>NextToken</code> response element is present and has a value (is not null).
     * Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the
     * next part of the results.
     * </p>
     * <note>
     * <p>
     * An API operation can return fewer results than the maximum even when there are more results available. You should
     * check <code>NextToken</code> after every operation to ensure that you receive all of the results.
     * </p>
     * </note>
     * 
     * @return The maximum number of results that you want included on each page of the response. If you do not include
     *         this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond
     *         those included in the current response, the <code>NextToken</code> response element is present and has a
     *         value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call
     *         to the operation to get the next part of the results.</p> <note>
     *         <p>
     *         An API operation can return fewer results than the maximum even when there are more results available.
     *         You should check <code>NextToken</code> after every operation to ensure that you receive all of the
     *         results.
     *         </p>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * resource name (ARN)</a> of the view to use for the query. If you don't specify a value for this parameter, then
     * the operation automatically uses the default view for the Amazon Web Services Region in which you called this
     * operation. If the Region either doesn't have a default view or if you don't have permission to use the default
     * view, then the operation fails with a <code>401 Unauthorized</code> exception.
     * </p>
     * 
     * @return Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         resource name (ARN)</a> of the view to use for the query. If you don't specify a value for this
     *         parameter, then the operation automatically uses the default view for the Amazon Web Services Region in
     *         which you called this operation. If the Region either doesn't have a default view or if you don't have
     *         permission to use the default view, then the operation fails with a <code>401 Unauthorized</code>
     *         exception.
     */
    public final String viewArn() {
        return viewArn;
    }

    /**
     * <p>
     * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
     * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
     * value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @return The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
     *         previous request. A <code>NextToken</code> response indicates that more output is available. Set this
     *         parameter to the value of the previous call's <code>NextToken</code> response to indicate where the
     *         output should continue from. The pagination tokens expire after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(viewArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest) obj;
        return Objects.equals(queryString(), other.queryString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(viewArn(), other.viewArn()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchRequest")
                .add("QueryString", queryString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxResults", maxResults()).add("ViewArn", viewArn()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ViewArn":
            return Optional.ofNullable(clazz.cast(viewArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ViewArn", VIEW_ARN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRequest, T> g) {
        return obj -> g.apply((SearchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Request.Builder, SdkPojo, CopyableBuilder<Builder, SearchRequest> {
        /**
         * <p>
         * A string that includes keywords and filters that specify the resources that you want to include in the
         * results.
         * </p>
         * <p>
         * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
         * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html">Search
         * query syntax reference for Resource Explorer</a>.
         * </p>
         * <p>
         * The search is completely case insensitive. You can specify an empty string to return all results up to the
         * limit of 1,000 total results.
         * </p>
         * <note>
         * <p>
         * The operation can return only the first 1,000 results. If the resource you want is not included, then use a
         * different value for <code>QueryString</code> to refine the results.
         * </p>
         * </note>
         * 
         * @param queryString
         *        A string that includes keywords and filters that specify the resources that you want to include in the
         *        results.</p>
         *        <p>
         *        For the complete syntax supported by the <code>QueryString</code> parameter, see <a
         *        href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html"
         *        >Search query syntax reference for Resource Explorer</a>.
         *        </p>
         *        <p>
         *        The search is completely case insensitive. You can specify an empty string to return all results up to
         *        the limit of 1,000 total results.
         *        </p>
         *        <note>
         *        <p>
         *        The operation can return only the first 1,000 results. If the resource you want is not included, then
         *        use a different value for <code>QueryString</code> to refine the results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The maximum number of results that you want included on each page of the response. If you do not include this
         * parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those
         * included in the current response, the <code>NextToken</code> response element is present and has a value (is
         * not null). Include that value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next part of the results.
         * </p>
         * <note>
         * <p>
         * An API operation can return fewer results than the maximum even when there are more results available. You
         * should check <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * </p>
         * </note>
         * 
         * @param maxResults
         *        The maximum number of results that you want included on each page of the response. If you do not
         *        include this parameter, it defaults to a value appropriate to the operation. If additional items exist
         *        beyond those included in the current response, the <code>NextToken</code> response element is present
         *        and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in
         *        the next call to the operation to get the next part of the results.</p> <note>
         *        <p>
         *        An API operation can return fewer results than the maximum even when there are more results available.
         *        You should check <code>NextToken</code> after every operation to ensure that you receive all of the
         *        results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * resource name (ARN)</a> of the view to use for the query. If you don't specify a value for this parameter,
         * then the operation automatically uses the default view for the Amazon Web Services Region in which you called
         * this operation. If the Region either doesn't have a default view or if you don't have permission to use the
         * default view, then the operation fails with a <code>401 Unauthorized</code> exception.
         * </p>
         * 
         * @param viewArn
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         *        (ARN)</a> of the view to use for the query. If you don't specify a value for this parameter, then the
         *        operation automatically uses the default view for the Amazon Web Services Region in which you called
         *        this operation. If the Region either doesn't have a default view or if you don't have permission to
         *        use the default view, then the operation fails with a <code>401 Unauthorized</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewArn(String viewArn);

        /**
         * <p>
         * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
         * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
         * value of the previous call's <code>NextToken</code> response to indicate where the output should continue
         * from. The pagination tokens expire after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
         *        previous request. A <code>NextToken</code> response indicates that more output is available. Set this
         *        parameter to the value of the previous call's <code>NextToken</code> response to indicate where the
         *        output should continue from. The pagination tokens expire after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceExplorer2Request.BuilderImpl implements Builder {
        private String queryString;

        private Integer maxResults;

        private String viewArn;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRequest model) {
            super(model);
            queryString(model.queryString);
            maxResults(model.maxResults);
            viewArn(model.viewArn);
            nextToken(model.nextToken);
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getViewArn() {
            return viewArn;
        }

        public final void setViewArn(String viewArn) {
            this.viewArn = viewArn;
        }

        @Override
        public final Builder viewArn(String viewArn) {
            this.viewArn = viewArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
