/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the number of results that match the query. At this time, Amazon Web Services Resource Explorer
 * doesn't count more than 1,000 matches for any query. This structure provides information about whether the query
 * exceeded this limit.
 * </p>
 * <p>
 * This field is included in every page when you paginate the results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCount implements SdkPojo, Serializable, ToCopyableBuilder<ResourceCount.Builder, ResourceCount> {
    private static final SdkField<Long> TOTAL_RESOURCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalResources").getter(getter(ResourceCount::totalResources)).setter(setter(Builder::totalResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResources").build()).build();

    private static final SdkField<Boolean> COMPLETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Complete").getter(getter(ResourceCount::complete)).setter(setter(Builder::complete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Complete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_RESOURCES_FIELD,
            COMPLETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long totalResources;

    private final Boolean complete;

    private ResourceCount(BuilderImpl builder) {
        this.totalResources = builder.totalResources;
        this.complete = builder.complete;
    }

    /**
     * <p>
     * The number of resources that match the search query. This value can't exceed 1,000. If there are more than 1,000
     * resources that match the query, then only 1,000 are counted and the <code>Complete</code> field is set to false.
     * We recommend that you refine your query to return a smaller number of results.
     * </p>
     * 
     * @return The number of resources that match the search query. This value can't exceed 1,000. If there are more
     *         than 1,000 resources that match the query, then only 1,000 are counted and the <code>Complete</code>
     *         field is set to false. We recommend that you refine your query to return a smaller number of results.
     */
    public final Long totalResources() {
        return totalResources;
    }

    /**
     * <p>
     * Indicates whether the <code>TotalResources</code> value represents an exhaustive count of search results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>True</code>, it indicates that the search was exhaustive. Every resource that matches the query was
     * counted.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>False</code>, then the search reached the limit of 1,000 matching results, and stopped counting.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the <code>TotalResources</code> value represents an exhaustive count of search
     *         results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>True</code>, it indicates that the search was exhaustive. Every resource that matches the query
     *         was counted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>False</code>, then the search reached the limit of 1,000 matching results, and stopped counting.
     *         </p>
     *         </li>
     */
    public final Boolean complete() {
        return complete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalResources());
        hashCode = 31 * hashCode + Objects.hashCode(complete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCount)) {
            return false;
        }
        ResourceCount other = (ResourceCount) obj;
        return Objects.equals(totalResources(), other.totalResources()) && Objects.equals(complete(), other.complete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceCount").add("TotalResources", totalResources()).add("Complete", complete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalResources":
            return Optional.ofNullable(clazz.cast(totalResources()));
        case "Complete":
            return Optional.ofNullable(clazz.cast(complete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalResources", TOTAL_RESOURCES_FIELD);
        map.put("Complete", COMPLETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceCount, T> g) {
        return obj -> g.apply((ResourceCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCount> {
        /**
         * <p>
         * The number of resources that match the search query. This value can't exceed 1,000. If there are more than
         * 1,000 resources that match the query, then only 1,000 are counted and the <code>Complete</code> field is set
         * to false. We recommend that you refine your query to return a smaller number of results.
         * </p>
         * 
         * @param totalResources
         *        The number of resources that match the search query. This value can't exceed 1,000. If there are more
         *        than 1,000 resources that match the query, then only 1,000 are counted and the <code>Complete</code>
         *        field is set to false. We recommend that you refine your query to return a smaller number of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResources(Long totalResources);

        /**
         * <p>
         * Indicates whether the <code>TotalResources</code> value represents an exhaustive count of search results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>True</code>, it indicates that the search was exhaustive. Every resource that matches the query was
         * counted.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>False</code>, then the search reached the limit of 1,000 matching results, and stopped counting.
         * </p>
         * </li>
         * </ul>
         * 
         * @param complete
         *        Indicates whether the <code>TotalResources</code> value represents an exhaustive count of search
         *        results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>True</code>, it indicates that the search was exhaustive. Every resource that matches the
         *        query was counted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>False</code>, then the search reached the limit of 1,000 matching results, and stopped
         *        counting.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complete(Boolean complete);
    }

    static final class BuilderImpl implements Builder {
        private Long totalResources;

        private Boolean complete;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCount model) {
            totalResources(model.totalResources);
            complete(model.complete);
        }

        public final Long getTotalResources() {
            return totalResources;
        }

        public final void setTotalResources(Long totalResources) {
            this.totalResources = totalResources;
        }

        @Override
        public final Builder totalResources(Long totalResources) {
            this.totalResources = totalResources;
            return this;
        }

        public final Boolean getComplete() {
            return complete;
        }

        public final void setComplete(Boolean complete) {
            this.complete = complete;
        }

        @Override
        public final Builder complete(Boolean complete) {
            this.complete = complete;
            return this;
        }

        @Override
        public ResourceCount build() {
            return new ResourceCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
