/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Web Services-managed view is how other Amazon Web Services services can access resource information indexed
 * by Resource Explorer for your Amazon Web Services account or organization with your consent. For more information,
 * see <a href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Managed
 * views</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedView implements SdkPojo, Serializable, ToCopyableBuilder<ManagedView.Builder, ManagedView> {
    private static final SdkField<String> MANAGED_VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedViewArn").getter(getter(ManagedView::managedViewArn)).setter(setter(Builder::managedViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedViewArn").build()).build();

    private static final SdkField<String> MANAGED_VIEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedViewName").getter(getter(ManagedView::managedViewName)).setter(setter(Builder::managedViewName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedViewName").build()).build();

    private static final SdkField<String> TRUSTED_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedService").getter(getter(ManagedView::trustedService)).setter(setter(Builder::trustedService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedService").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(ManagedView::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(ManagedView::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(ManagedView::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField
            .<List<IncludedProperty>> builder(MarshallingType.LIST)
            .memberName("IncludedProperties")
            .getter(getter(ManagedView::includedProperties))
            .setter(setter(Builder::includedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncludedProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncludedProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.<SearchFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(ManagedView::filters)).setter(setter(Builder::filters))
            .constructor(SearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePolicy").getter(getter(ManagedView::resourcePolicy)).setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(ManagedView::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_VIEW_ARN_FIELD,
            MANAGED_VIEW_NAME_FIELD, TRUSTED_SERVICE_FIELD, LAST_UPDATED_AT_FIELD, OWNER_FIELD, SCOPE_FIELD,
            INCLUDED_PROPERTIES_FIELD, FILTERS_FIELD, RESOURCE_POLICY_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String managedViewArn;

    private final String managedViewName;

    private final String trustedService;

    private final Instant lastUpdatedAt;

    private final String owner;

    private final String scope;

    private final List<IncludedProperty> includedProperties;

    private final SearchFilter filters;

    private final String resourcePolicy;

    private final String version;

    private ManagedView(BuilderImpl builder) {
        this.managedViewArn = builder.managedViewArn;
        this.managedViewName = builder.managedViewName;
        this.trustedService = builder.trustedService;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.owner = builder.owner;
        this.scope = builder.scope;
        this.includedProperties = builder.includedProperties;
        this.filters = builder.filters;
        this.resourcePolicy = builder.resourcePolicy;
        this.version = builder.version;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of the managed view.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of the managed view.
     */
    public final String managedViewArn() {
        return managedViewArn;
    }

    /**
     * <p>
     * The name of the managed view.
     * </p>
     * 
     * @return The name of the managed view.
     */
    public final String managedViewName() {
        return managedViewName;
    }

    /**
     * <p>
     * The service principal of the Amazon Web Services service that created and manages the managed view.
     * </p>
     * 
     * @return The service principal of the Amazon Web Services service that created and manages the managed view.
     */
    public final String trustedService() {
        return trustedService;
    }

    /**
     * <p>
     * The date and time when this managed view was last modified.
     * </p>
     * 
     * @return The date and time when this managed view was last modified.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Web Services account that owns this managed view.
     * </p>
     * 
     * @return The Amazon Web Services account that owns this managed view.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of an Amazon Web Services account or organization that specifies whether this managed view includes
     * resources from only the specified Amazon Web Services account or all accounts in the specified organization.
     * </p>
     * 
     * @return An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of an Amazon Web Services account or organization that specifies whether this managed view
     *         includes resources from only the specified Amazon Web Services account or all accounts in the specified
     *         organization.
     */
    public final String scope() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludedProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludedProperties() {
        return includedProperties != null && !(includedProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that contains additional information about the managed view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludedProperties} method.
     * </p>
     * 
     * @return A structure that contains additional information about the managed view.
     */
    public final List<IncludedProperty> includedProperties() {
        return includedProperties;
    }

    /**
     * Returns the value of the Filters property for this object.
     * 
     * @return The value of the Filters property for this object.
     */
    public final SearchFilter filters() {
        return filters;
    }

    /**
     * <p>
     * The resource policy that defines access to the managed view. To learn more about this policy, review <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Managed views</a>.
     * </p>
     * 
     * @return The resource policy that defines access to the managed view. To learn more about this policy, review <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Managed
     *         views</a>.
     */
    public final String resourcePolicy() {
        return resourcePolicy;
    }

    /**
     * <p>
     * The version of the managed view.
     * </p>
     * 
     * @return The version of the managed view.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(managedViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(managedViewName());
        hashCode = 31 * hashCode + Objects.hashCode(trustedService());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedProperties() ? includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedView)) {
            return false;
        }
        ManagedView other = (ManagedView) obj;
        return Objects.equals(managedViewArn(), other.managedViewArn())
                && Objects.equals(managedViewName(), other.managedViewName())
                && Objects.equals(trustedService(), other.trustedService())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(owner(), other.owner())
                && Objects.equals(scope(), other.scope()) && hasIncludedProperties() == other.hasIncludedProperties()
                && Objects.equals(includedProperties(), other.includedProperties()) && Objects.equals(filters(), other.filters())
                && Objects.equals(resourcePolicy(), other.resourcePolicy()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedView").add("ManagedViewArn", managedViewArn()).add("ManagedViewName", managedViewName())
                .add("TrustedService", trustedService()).add("LastUpdatedAt", lastUpdatedAt()).add("Owner", owner())
                .add("Scope", scope()).add("IncludedProperties", hasIncludedProperties() ? includedProperties() : null)
                .add("Filters", filters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourcePolicy", resourcePolicy()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedViewArn":
            return Optional.ofNullable(clazz.cast(managedViewArn()));
        case "ManagedViewName":
            return Optional.ofNullable(clazz.cast(managedViewName()));
        case "TrustedService":
            return Optional.ofNullable(clazz.cast(trustedService()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "IncludedProperties":
            return Optional.ofNullable(clazz.cast(includedProperties()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedViewArn", MANAGED_VIEW_ARN_FIELD);
        map.put("ManagedViewName", MANAGED_VIEW_NAME_FIELD);
        map.put("TrustedService", TRUSTED_SERVICE_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("IncludedProperties", INCLUDED_PROPERTIES_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("ResourcePolicy", RESOURCE_POLICY_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedView, T> g) {
        return obj -> g.apply((ManagedView) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedView> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of the managed view.
         * </p>
         * 
         * @param managedViewArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of the managed view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedViewArn(String managedViewArn);

        /**
         * <p>
         * The name of the managed view.
         * </p>
         * 
         * @param managedViewName
         *        The name of the managed view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedViewName(String managedViewName);

        /**
         * <p>
         * The service principal of the Amazon Web Services service that created and manages the managed view.
         * </p>
         * 
         * @param trustedService
         *        The service principal of the Amazon Web Services service that created and manages the managed view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedService(String trustedService);

        /**
         * <p>
         * The date and time when this managed view was last modified.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time when this managed view was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The Amazon Web Services account that owns this managed view.
         * </p>
         * 
         * @param owner
         *        The Amazon Web Services account that owns this managed view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of an Amazon Web Services account or organization that specifies whether this managed view includes
         * resources from only the specified Amazon Web Services account or all accounts in the specified organization.
         * </p>
         * 
         * @param scope
         *        An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of an Amazon Web Services account or organization that specifies whether this
         *        managed view includes resources from only the specified Amazon Web Services account or all accounts in
         *        the specified organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * A structure that contains additional information about the managed view.
         * </p>
         * 
         * @param includedProperties
         *        A structure that contains additional information about the managed view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(Collection<IncludedProperty> includedProperties);

        /**
         * <p>
         * A structure that contains additional information about the managed view.
         * </p>
         * 
         * @param includedProperties
         *        A structure that contains additional information about the managed view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(IncludedProperty... includedProperties);

        /**
         * <p>
         * A structure that contains additional information about the managed view.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #includedProperties(List<IncludedProperty>)}.
         * 
         * @param includedProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includedProperties(java.util.Collection<IncludedProperty>)
         */
        Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties);

        /**
         * Sets the value of the Filters property for this object.
         *
         * @param filters
         *        The new value for the Filters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SearchFilter filters);

        /**
         * Sets the value of the Filters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SearchFilter.Builder} avoiding the need
         * to create one manually via {@link SearchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(SearchFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link SearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(SearchFilter)
         */
        default Builder filters(Consumer<SearchFilter.Builder> filters) {
            return filters(SearchFilter.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The resource policy that defines access to the managed view. To learn more about this policy, review <a
         * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Managed
         * views</a>.
         * </p>
         * 
         * @param resourcePolicy
         *        The resource policy that defines access to the managed view. To learn more about this policy, review
         *        <a
         *        href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html">Managed
         *        views</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        /**
         * <p>
         * The version of the managed view.
         * </p>
         * 
         * @param version
         *        The version of the managed view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String managedViewArn;

        private String managedViewName;

        private String trustedService;

        private Instant lastUpdatedAt;

        private String owner;

        private String scope;

        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();

        private SearchFilter filters;

        private String resourcePolicy;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedView model) {
            managedViewArn(model.managedViewArn);
            managedViewName(model.managedViewName);
            trustedService(model.trustedService);
            lastUpdatedAt(model.lastUpdatedAt);
            owner(model.owner);
            scope(model.scope);
            includedProperties(model.includedProperties);
            filters(model.filters);
            resourcePolicy(model.resourcePolicy);
            version(model.version);
        }

        public final String getManagedViewArn() {
            return managedViewArn;
        }

        public final void setManagedViewArn(String managedViewArn) {
            this.managedViewArn = managedViewArn;
        }

        @Override
        public final Builder managedViewArn(String managedViewArn) {
            this.managedViewArn = managedViewArn;
            return this;
        }

        public final String getManagedViewName() {
            return managedViewName;
        }

        public final void setManagedViewName(String managedViewName) {
            this.managedViewName = managedViewName;
        }

        @Override
        public final Builder managedViewName(String managedViewName) {
            this.managedViewName = managedViewName;
            return this;
        }

        public final String getTrustedService() {
            return trustedService;
        }

        public final void setTrustedService(String trustedService) {
            this.trustedService = trustedService;
        }

        @Override
        public final Builder trustedService(String trustedService) {
            this.trustedService = trustedService;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty... includedProperties) {
            includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties) {
            includedProperties(Stream.of(includedProperties).map(c -> IncludedProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SearchFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ManagedView build() {
            return new ManagedView(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
