/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<ListResourcesResponse.Builder, ListResourcesResponse> {
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(ListResourcesResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewArn").getter(getter(ListResourcesResponse::viewArn)).setter(setter(Builder::viewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD,
            NEXT_TOKEN_FIELD, VIEW_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Resource> resources;

    private final String nextToken;

    private final String viewArn;

    private ListResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
        this.viewArn = builder.viewArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of structures that describe the resources that match the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return The list of structures that describe the resources that match the query.
     */
    public final List<Resource> resources() {
        return resources;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>. The pagination tokens expire after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the view that this operation used to perform the search.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the view that this operation used to perform the search.
     */
    public final String viewArn() {
        return viewArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(viewArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesResponse)) {
            return false;
        }
        ListResourcesResponse other = (ListResourcesResponse) obj;
        return hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(viewArn(), other.viewArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourcesResponse").add("Resources", hasResources() ? resources() : null)
                .add("NextToken", nextToken()).add("ViewArn", viewArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ViewArn":
            return Optional.ofNullable(clazz.cast(viewArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Resources", RESOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ViewArn", VIEW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesResponse, T> g) {
        return obj -> g.apply((ListResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesResponse> {
        /**
         * <p>
         * The list of structures that describe the resources that match the query.
         * </p>
         * 
         * @param resources
         *        The list of structures that describe the resources that match the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * The list of structures that describe the resources that match the query.
         * </p>
         * 
         * @param resources
         *        The list of structures that describe the resources that match the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * The list of structures that describe the resources that match the query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.Resource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.resourceexplorer2.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.Resource.Builder#build()} is called
         * immediately and its result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>. The pagination tokens expire after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>. The pagination tokens expire after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon resource name (ARN) of the view that this operation used to perform the search.
         * </p>
         * 
         * @param viewArn
         *        The Amazon resource name (ARN) of the view that this operation used to perform the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewArn(String viewArn);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String viewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesResponse model) {
            super(model);
            resources(model.resources);
            nextToken(model.nextToken);
            viewArn(model.viewArn);
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getViewArn() {
            return viewArn;
        }

        public final void setViewArn(String viewArn) {
            this.viewArn = viewArn;
        }

        @Override
        public final Builder viewArn(String viewArn) {
            this.viewArn = viewArn;
            return this;
        }

        @Override
        public ListResourcesResponse build() {
            return new ListResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
