/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndexesForMembersRequest extends ResourceExplorer2Request implements
        ToCopyableBuilder<ListIndexesForMembersRequest.Builder, ListIndexesForMembersRequest> {
    private static final SdkField<List<String>> ACCOUNT_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIdList")
            .getter(getter(ListIndexesForMembersRequest::accountIdList))
            .setter(setter(Builder::accountIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListIndexesForMembersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIndexesForMembersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_LIST_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> accountIdList;

    private final Integer maxResults;

    private final String nextToken;

    private ListIndexesForMembersRequest(BuilderImpl builder) {
        super(builder);
        this.accountIdList = builder.accountIdList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIdList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountIdList() {
        return accountIdList != null && !(accountIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account IDs will limit the output to only indexes from these accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIdList} method.
     * </p>
     * 
     * @return The account IDs will limit the output to only indexes from these accounts.
     */
    public final List<String> accountIdList() {
        return accountIdList;
    }

    /**
     * <p>
     * The maximum number of results that you want included on each page of the response. If you do not include this
     * parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included
     * in the current response, the <code>NextToken</code> response element is present and has a value (is not null).
     * Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the
     * next part of the results.
     * </p>
     * <note>
     * <p>
     * An API operation can return fewer results than the maximum even when there are more results available. You should
     * check <code>NextToken</code> after every operation to ensure that you receive all of the results.
     * </p>
     * </note>
     * 
     * @return The maximum number of results that you want included on each page of the response. If you do not include
     *         this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond
     *         those included in the current response, the <code>NextToken</code> response element is present and has a
     *         value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call
     *         to the operation to get the next part of the results.</p> <note>
     *         <p>
     *         An API operation can return fewer results than the maximum even when there are more results available.
     *         You should check <code>NextToken</code> after every operation to ensure that you receive all of the
     *         results.
     *         </p>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
     * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
     * value of the previous call's <code>NextToken</code> response to indicate where the output should continue from.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @return The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
     *         previous request. A <code>NextToken</code> response indicates that more output is available. Set this
     *         parameter to the value of the previous call's <code>NextToken</code> response to indicate where the
     *         output should continue from. The pagination tokens expire after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdList() ? accountIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexesForMembersRequest)) {
            return false;
        }
        ListIndexesForMembersRequest other = (ListIndexesForMembersRequest) obj;
        return hasAccountIdList() == other.hasAccountIdList() && Objects.equals(accountIdList(), other.accountIdList())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIndexesForMembersRequest").add("AccountIdList", hasAccountIdList() ? accountIdList() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountIdList":
            return Optional.ofNullable(clazz.cast(accountIdList()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountIdList", ACCOUNT_ID_LIST_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIndexesForMembersRequest, T> g) {
        return obj -> g.apply((ListIndexesForMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIndexesForMembersRequest> {
        /**
         * <p>
         * The account IDs will limit the output to only indexes from these accounts.
         * </p>
         * 
         * @param accountIdList
         *        The account IDs will limit the output to only indexes from these accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdList(Collection<String> accountIdList);

        /**
         * <p>
         * The account IDs will limit the output to only indexes from these accounts.
         * </p>
         * 
         * @param accountIdList
         *        The account IDs will limit the output to only indexes from these accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdList(String... accountIdList);

        /**
         * <p>
         * The maximum number of results that you want included on each page of the response. If you do not include this
         * parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those
         * included in the current response, the <code>NextToken</code> response element is present and has a value (is
         * not null). Include that value as the <code>NextToken</code> request parameter in the next call to the
         * operation to get the next part of the results.
         * </p>
         * <note>
         * <p>
         * An API operation can return fewer results than the maximum even when there are more results available. You
         * should check <code>NextToken</code> after every operation to ensure that you receive all of the results.
         * </p>
         * </note>
         * 
         * @param maxResults
         *        The maximum number of results that you want included on each page of the response. If you do not
         *        include this parameter, it defaults to a value appropriate to the operation. If additional items exist
         *        beyond those included in the current response, the <code>NextToken</code> response element is present
         *        and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in
         *        the next call to the operation to get the next part of the results.</p> <note>
         *        <p>
         *        An API operation can return fewer results than the maximum even when there are more results available.
         *        You should check <code>NextToken</code> after every operation to ensure that you receive all of the
         *        results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
         * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
         * value of the previous call's <code>NextToken</code> response to indicate where the output should continue
         * from. The pagination tokens expire after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
         *        previous request. A <code>NextToken</code> response indicates that more output is available. Set this
         *        parameter to the value of the previous call's <code>NextToken</code> response to indicate where the
         *        output should continue from. The pagination tokens expire after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceExplorer2Request.BuilderImpl implements Builder {
        private List<String> accountIdList = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexesForMembersRequest model) {
            super(model);
            accountIdList(model.accountIdList);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAccountIdList() {
            if (accountIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIdList;
        }

        public final void setAccountIdList(Collection<String> accountIdList) {
            this.accountIdList = ListIndexesForMembersInputAccountIdListListCopier.copy(accountIdList);
        }

        @Override
        public final Builder accountIdList(Collection<String> accountIdList) {
            this.accountIdList = ListIndexesForMembersInputAccountIdListListCopier.copy(accountIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdList(String... accountIdList) {
            accountIdList(Arrays.asList(accountIdList));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIndexesForMembersRequest build() {
            return new ListIndexesForMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
