/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Response;
import software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetails;
import software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamingAccessForServicesResponse
extends ResourceExplorer2Response
implements ToCopyableBuilder<Builder, ListStreamingAccessForServicesResponse> {
    private static final SdkField<List<StreamingAccessDetails>> STREAMING_ACCESS_FOR_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StreamingAccessForServices").getter(ListStreamingAccessForServicesResponse.getter(ListStreamingAccessForServicesResponse::streamingAccessForServices)).setter(ListStreamingAccessForServicesResponse.setter(Builder::streamingAccessForServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingAccessForServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamingAccessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStreamingAccessForServicesResponse.getter(ListStreamingAccessForServicesResponse::nextToken)).setter(ListStreamingAccessForServicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_ACCESS_FOR_SERVICES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStreamingAccessForServicesResponse.memberNameToFieldInitializer();
    private final List<StreamingAccessDetails> streamingAccessForServices;
    private final String nextToken;

    private ListStreamingAccessForServicesResponse(BuilderImpl builder) {
        super(builder);
        this.streamingAccessForServices = builder.streamingAccessForServices;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStreamingAccessForServices() {
        return this.streamingAccessForServices != null && !(this.streamingAccessForServices instanceof SdkAutoConstructList);
    }

    public final List<StreamingAccessDetails> streamingAccessForServices() {
        return this.streamingAccessForServices;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamingAccessForServices() ? this.streamingAccessForServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingAccessForServicesResponse)) {
            return false;
        }
        ListStreamingAccessForServicesResponse other = (ListStreamingAccessForServicesResponse)((Object)obj);
        return this.hasStreamingAccessForServices() == other.hasStreamingAccessForServices() && Objects.equals(this.streamingAccessForServices(), other.streamingAccessForServices()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamingAccessForServicesResponse").add("StreamingAccessForServices", this.hasStreamingAccessForServices() ? this.streamingAccessForServices() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingAccessForServices": {
                return Optional.ofNullable(clazz.cast(this.streamingAccessForServices()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamingAccessForServices", STREAMING_ACCESS_FOR_SERVICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingAccessForServicesResponse, T> g) {
        return obj -> g.apply((ListStreamingAccessForServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Response.BuilderImpl
    implements Builder {
        private List<StreamingAccessDetails> streamingAccessForServices = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingAccessForServicesResponse model) {
            super(model);
            this.streamingAccessForServices(model.streamingAccessForServices);
            this.nextToken(model.nextToken);
        }

        public final List<StreamingAccessDetails.Builder> getStreamingAccessForServices() {
            List<StreamingAccessDetails.Builder> result = StreamingAccessDetailsListCopier.copyToBuilder(this.streamingAccessForServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamingAccessForServices(Collection<StreamingAccessDetails.BuilderImpl> streamingAccessForServices) {
            this.streamingAccessForServices = StreamingAccessDetailsListCopier.copyFromBuilder(streamingAccessForServices);
        }

        @Override
        public final Builder streamingAccessForServices(Collection<StreamingAccessDetails> streamingAccessForServices) {
            this.streamingAccessForServices = StreamingAccessDetailsListCopier.copy(streamingAccessForServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingAccessForServices(StreamingAccessDetails ... streamingAccessForServices) {
            this.streamingAccessForServices(Arrays.asList(streamingAccessForServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingAccessForServices(Consumer<StreamingAccessDetails.Builder> ... streamingAccessForServices) {
            this.streamingAccessForServices(Stream.of(streamingAccessForServices).map(c -> (StreamingAccessDetails)((StreamingAccessDetails.Builder)StreamingAccessDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStreamingAccessForServicesResponse build() {
            return new ListStreamingAccessForServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResourceExplorer2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamingAccessForServicesResponse> {
        public Builder streamingAccessForServices(Collection<StreamingAccessDetails> var1);

        public Builder streamingAccessForServices(StreamingAccessDetails ... var1);

        public Builder streamingAccessForServices(Consumer<StreamingAccessDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

