/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewErrorsCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Response;
import software.amazon.awssdk.services.resourceexplorer2.model.View;
import software.amazon.awssdk.services.resourceexplorer2.model.ViewListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetViewResponse
extends ResourceExplorer2Response
implements ToCopyableBuilder<Builder, BatchGetViewResponse> {
    private static final SdkField<List<BatchGetViewError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetViewResponse.getter(BatchGetViewResponse::errors)).setter(BatchGetViewResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetViewError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<View>> VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Views").getter(BatchGetViewResponse.getter(BatchGetViewResponse::views)).setter(BatchGetViewResponse.setter(Builder::views)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Views").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(View::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, VIEWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Errors", ERRORS_FIELD);
            this.put("Views", VIEWS_FIELD);
        }
    });
    private final List<BatchGetViewError> errors;
    private final List<View> views;

    private BatchGetViewResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.views = builder.views;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetViewError> errors() {
        return this.errors;
    }

    public final boolean hasViews() {
        return this.views != null && !(this.views instanceof SdkAutoConstructList);
    }

    public final List<View> views() {
        return this.views;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViews() ? this.views() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetViewResponse)) {
            return false;
        }
        BatchGetViewResponse other = (BatchGetViewResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasViews() == other.hasViews() && Objects.equals(this.views(), other.views());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetViewResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("Views", this.hasViews() ? this.views() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Views": {
                return Optional.ofNullable(clazz.cast(this.views()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetViewResponse, T> g) {
        return obj -> g.apply((BatchGetViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Response.BuilderImpl
    implements Builder {
        private List<BatchGetViewError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<View> views = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetViewResponse model) {
            super(model);
            this.errors(model.errors);
            this.views(model.views);
        }

        public final List<BatchGetViewError.Builder> getErrors() {
            List<BatchGetViewError.Builder> result = BatchGetViewErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetViewError.BuilderImpl> errors) {
            this.errors = BatchGetViewErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetViewError> errors) {
            this.errors = BatchGetViewErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetViewError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetViewError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetViewError)((BatchGetViewError.Builder)BatchGetViewError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<View.Builder> getViews() {
            List<View.Builder> result = ViewListCopier.copyToBuilder(this.views);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViews(Collection<View.BuilderImpl> views) {
            this.views = ViewListCopier.copyFromBuilder(views);
        }

        @Override
        public final Builder views(Collection<View> views) {
            this.views = ViewListCopier.copy(views);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder views(View ... views) {
            this.views(Arrays.asList(views));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder views(Consumer<View.Builder> ... views) {
            this.views(Stream.of(views).map(c -> (View)((View.Builder)View.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetViewResponse build() {
            return new BatchGetViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResourceExplorer2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetViewResponse> {
        public Builder errors(Collection<BatchGetViewError> var1);

        public Builder errors(BatchGetViewError ... var1);

        public Builder errors(Consumer<BatchGetViewError.Builder> ... var1);

        public Builder views(Collection<View> var1);

        public Builder views(View ... var1);

        public Builder views(Consumer<View.Builder> ... var1);
    }
}

