/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A view is a structure that defines a set of filters that provide a view into the information in the Amazon Web
 * Services Resource Explorer index. The filters specify which information from the index is visible to the users of the
 * view. For example, you can specify filters that include only resources that are tagged with the key "ENV" and the
 * value "DEVELOPMENT" in the results returned by this view. You could also create a second view that includes only
 * resources that are tagged with "ENV" and "PRODUCTION".
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class View implements SdkPojo, Serializable, ToCopyableBuilder<View.Builder, View> {
    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.<SearchFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(View::filters)).setter(setter(Builder::filters))
            .constructor(SearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField
            .<List<IncludedProperty>> builder(MarshallingType.LIST)
            .memberName("IncludedProperties")
            .getter(getter(View::includedProperties))
            .setter(setter(Builder::includedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncludedProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncludedProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(View::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(View::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(View::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewArn").getter(getter(View::viewArn)).setter(setter(Builder::viewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            INCLUDED_PROPERTIES_FIELD, LAST_UPDATED_AT_FIELD, OWNER_FIELD, SCOPE_FIELD, VIEW_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final SearchFilter filters;

    private final List<IncludedProperty> includedProperties;

    private final Instant lastUpdatedAt;

    private final String owner;

    private final String scope;

    private final String viewArn;

    private View(BuilderImpl builder) {
        this.filters = builder.filters;
        this.includedProperties = builder.includedProperties;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.owner = builder.owner;
        this.scope = builder.scope;
        this.viewArn = builder.viewArn;
    }

    /**
     * <p>
     * An array of <a>SearchFilter</a> objects that specify which resources can be included in the results of queries
     * made using this view.
     * </p>
     * 
     * @return An array of <a>SearchFilter</a> objects that specify which resources can be included in the results of
     *         queries made using this view.
     */
    public final SearchFilter filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludedProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludedProperties() {
        return includedProperties != null && !(includedProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that contains additional information about the view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludedProperties} method.
     * </p>
     * 
     * @return A structure that contains additional information about the view.
     */
    public final List<IncludedProperty> includedProperties() {
        return includedProperties;
    }

    /**
     * <p>
     * The date and time when this view was last modified.
     * </p>
     * 
     * @return The date and time when this view was last modified.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Web Services account that owns this view.
     * </p>
     * 
     * @return The Amazon Web Services account that owns this view.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of an Amazon Web Services account, an organization, or an organizational unit (OU) that specifies
     * whether this view includes resources from only the specified Amazon Web Services account, all accounts in the
     * specified organization, or all accounts in the specified OU.
     * </p>
     * <p>
     * If not specified, the value defaults to the Amazon Web Services account used to call this operation.
     * </p>
     * 
     * @return An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of an Amazon Web Services account, an organization, or an organizational unit (OU) that
     *         specifies whether this view includes resources from only the specified Amazon Web Services account, all
     *         accounts in the specified organization, or all accounts in the specified OU.</p>
     *         <p>
     *         If not specified, the value defaults to the Amazon Web Services account used to call this operation.
     */
    public final String scope() {
        return scope;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of the view.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of the view.
     */
    public final String viewArn() {
        return viewArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedProperties() ? includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(viewArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof View)) {
            return false;
        }
        View other = (View) obj;
        return Objects.equals(filters(), other.filters()) && hasIncludedProperties() == other.hasIncludedProperties()
                && Objects.equals(includedProperties(), other.includedProperties())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(owner(), other.owner())
                && Objects.equals(scope(), other.scope()) && Objects.equals(viewArn(), other.viewArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("View").add("Filters", filters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncludedProperties", hasIncludedProperties() ? includedProperties() : null)
                .add("LastUpdatedAt", lastUpdatedAt()).add("Owner", owner()).add("Scope", scope()).add("ViewArn", viewArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "IncludedProperties":
            return Optional.ofNullable(clazz.cast(includedProperties()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "ViewArn":
            return Optional.ofNullable(clazz.cast(viewArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<View, T> g) {
        return obj -> g.apply((View) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, View> {
        /**
         * <p>
         * An array of <a>SearchFilter</a> objects that specify which resources can be included in the results of
         * queries made using this view.
         * </p>
         * 
         * @param filters
         *        An array of <a>SearchFilter</a> objects that specify which resources can be included in the results of
         *        queries made using this view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SearchFilter filters);

        /**
         * <p>
         * An array of <a>SearchFilter</a> objects that specify which resources can be included in the results of
         * queries made using this view.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchFilter.Builder} avoiding the need
         * to create one manually via {@link SearchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(SearchFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link SearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(SearchFilter)
         */
        default Builder filters(Consumer<SearchFilter.Builder> filters) {
            return filters(SearchFilter.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * A structure that contains additional information about the view.
         * </p>
         * 
         * @param includedProperties
         *        A structure that contains additional information about the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(Collection<IncludedProperty> includedProperties);

        /**
         * <p>
         * A structure that contains additional information about the view.
         * </p>
         * 
         * @param includedProperties
         *        A structure that contains additional information about the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(IncludedProperty... includedProperties);

        /**
         * <p>
         * A structure that contains additional information about the view.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #includedProperties(List<IncludedProperty>)}.
         * 
         * @param includedProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includedProperties(java.util.Collection<IncludedProperty>)
         */
        Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties);

        /**
         * <p>
         * The date and time when this view was last modified.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time when this view was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The Amazon Web Services account that owns this view.
         * </p>
         * 
         * @param owner
         *        The Amazon Web Services account that owns this view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of an Amazon Web Services account, an organization, or an organizational unit (OU) that specifies
         * whether this view includes resources from only the specified Amazon Web Services account, all accounts in the
         * specified organization, or all accounts in the specified OU.
         * </p>
         * <p>
         * If not specified, the value defaults to the Amazon Web Services account used to call this operation.
         * </p>
         * 
         * @param scope
         *        An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of an Amazon Web Services account, an organization, or an organizational unit
         *        (OU) that specifies whether this view includes resources from only the specified Amazon Web Services
         *        account, all accounts in the specified organization, or all accounts in the specified OU.</p>
         *        <p>
         *        If not specified, the value defaults to the Amazon Web Services account used to call this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of the view.
         * </p>
         * 
         * @param viewArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewArn(String viewArn);
    }

    static final class BuilderImpl implements Builder {
        private SearchFilter filters;

        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdatedAt;

        private String owner;

        private String scope;

        private String viewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(View model) {
            filters(model.filters);
            includedProperties(model.includedProperties);
            lastUpdatedAt(model.lastUpdatedAt);
            owner(model.owner);
            scope(model.scope);
            viewArn(model.viewArn);
        }

        public final SearchFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty... includedProperties) {
            includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties) {
            includedProperties(Stream.of(includedProperties).map(c -> IncludedProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final String getViewArn() {
            return viewArn;
        }

        public final void setViewArn(String viewArn) {
            this.viewArn = viewArn;
        }

        @Override
        public final Builder viewArn(String viewArn) {
            this.viewArn = viewArn;
            return this;
        }

        @Override
        public View build() {
            return new View(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
