/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.resourceexplorer2.DefaultResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.DefaultResourceExplorer2BaseClientBuilder;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClientBuilder;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2ServiceClientConfiguration;
import software.amazon.awssdk.services.resourceexplorer2.endpoints.ResourceExplorer2EndpointProvider;

@SdkInternalApi
final class DefaultResourceExplorer2AsyncClientBuilder
extends DefaultResourceExplorer2BaseClientBuilder<ResourceExplorer2AsyncClientBuilder, ResourceExplorer2AsyncClient>
implements ResourceExplorer2AsyncClientBuilder {
    DefaultResourceExplorer2AsyncClientBuilder() {
    }

    @Override
    public DefaultResourceExplorer2AsyncClientBuilder endpointProvider(ResourceExplorer2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ResourceExplorer2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultResourceExplorer2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        ResourceExplorer2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultResourceExplorer2AsyncClient client = new DefaultResourceExplorer2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ResourceExplorer2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ResourceExplorer2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

