/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResourceError;
import software.amazon.awssdk.services.resiliencehub.model.ResourceErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceErrorsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceErrorsDetails> {
    private static final SdkField<Boolean> HAS_MORE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasMoreErrors").getter(ResourceErrorsDetails.getter(ResourceErrorsDetails::hasMoreErrors)).setter(ResourceErrorsDetails.setter(Builder::hasMoreErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreErrors").build()}).build();
    private static final SdkField<List<ResourceError>> RESOURCE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceErrors").getter(ResourceErrorsDetails.getter(ResourceErrorsDetails::resourceErrors)).setter(ResourceErrorsDetails.setter(Builder::resourceErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAS_MORE_ERRORS_FIELD, RESOURCE_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceErrorsDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean hasMoreErrors;
    private final List<ResourceError> resourceErrors;

    private ResourceErrorsDetails(BuilderImpl builder) {
        this.hasMoreErrors = builder.hasMoreErrors;
        this.resourceErrors = builder.resourceErrors;
    }

    public final Boolean hasMoreErrors() {
        return this.hasMoreErrors;
    }

    public final boolean hasResourceErrors() {
        return this.resourceErrors != null && !(this.resourceErrors instanceof SdkAutoConstructList);
    }

    public final List<ResourceError> resourceErrors() {
        return this.resourceErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceErrors() ? this.resourceErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceErrorsDetails)) {
            return false;
        }
        ResourceErrorsDetails other = (ResourceErrorsDetails)obj;
        return Objects.equals(this.hasMoreErrors(), other.hasMoreErrors()) && this.hasResourceErrors() == other.hasResourceErrors() && Objects.equals(this.resourceErrors(), other.resourceErrors());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceErrorsDetails").add("HasMoreErrors", (Object)this.hasMoreErrors()).add("ResourceErrors", this.hasResourceErrors() ? this.resourceErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hasMoreErrors": {
                return Optional.ofNullable(clazz.cast(this.hasMoreErrors()));
            }
            case "resourceErrors": {
                return Optional.ofNullable(clazz.cast(this.resourceErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hasMoreErrors", HAS_MORE_ERRORS_FIELD);
        map.put("resourceErrors", RESOURCE_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceErrorsDetails, T> g) {
        return obj -> g.apply((ResourceErrorsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean hasMoreErrors;
        private List<ResourceError> resourceErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceErrorsDetails model) {
            this.hasMoreErrors(model.hasMoreErrors);
            this.resourceErrors(model.resourceErrors);
        }

        public final Boolean getHasMoreErrors() {
            return this.hasMoreErrors;
        }

        public final void setHasMoreErrors(Boolean hasMoreErrors) {
            this.hasMoreErrors = hasMoreErrors;
        }

        @Override
        public final Builder hasMoreErrors(Boolean hasMoreErrors) {
            this.hasMoreErrors = hasMoreErrors;
            return this;
        }

        public final List<ResourceError.Builder> getResourceErrors() {
            List<ResourceError.Builder> result = ResourceErrorListCopier.copyToBuilder(this.resourceErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceErrors(Collection<ResourceError.BuilderImpl> resourceErrors) {
            this.resourceErrors = ResourceErrorListCopier.copyFromBuilder(resourceErrors);
        }

        @Override
        public final Builder resourceErrors(Collection<ResourceError> resourceErrors) {
            this.resourceErrors = ResourceErrorListCopier.copy(resourceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceErrors(ResourceError ... resourceErrors) {
            this.resourceErrors(Arrays.asList(resourceErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceErrors(Consumer<ResourceError.Builder> ... resourceErrors) {
            this.resourceErrors(Stream.of(resourceErrors).map(c -> (ResourceError)((ResourceError.Builder)ResourceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceErrorsDetails build() {
            return new ResourceErrorsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceErrorsDetails> {
        public Builder hasMoreErrors(Boolean var1);

        public Builder resourceErrors(Collection<ResourceError> var1);

        public Builder resourceErrors(ResourceError ... var1);

        public Builder resourceErrors(Consumer<ResourceError.Builder> ... var1);
    }
}

