/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceMapping;
import software.amazon.awssdk.services.resiliencehub.model.ResourceMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppVersionResourceMappingsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppVersionResourceMappingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppVersionResourceMappingsResponse.getter(ListAppVersionResourceMappingsResponse::nextToken)).setter(ListAppVersionResourceMappingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResourceMapping>> RESOURCE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceMappings").getter(ListAppVersionResourceMappingsResponse.getter(ListAppVersionResourceMappingsResponse::resourceMappings)).setter(ListAppVersionResourceMappingsResponse.setter(Builder::resourceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOURCE_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAppVersionResourceMappingsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ResourceMapping> resourceMappings;

    private ListAppVersionResourceMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourceMappings = builder.resourceMappings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResourceMappings() {
        return this.resourceMappings != null && !(this.resourceMappings instanceof SdkAutoConstructList);
    }

    public final List<ResourceMapping> resourceMappings() {
        return this.resourceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceMappings() ? this.resourceMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionResourceMappingsResponse)) {
            return false;
        }
        ListAppVersionResourceMappingsResponse other = (ListAppVersionResourceMappingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResourceMappings() == other.hasResourceMappings() && Objects.equals(this.resourceMappings(), other.resourceMappings());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppVersionResourceMappingsResponse").add("NextToken", (Object)this.nextToken()).add("ResourceMappings", this.hasResourceMappings() ? this.resourceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resourceMappings": {
                return Optional.ofNullable(clazz.cast(this.resourceMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceMappings", RESOURCE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionResourceMappingsResponse, T> g) {
        return obj -> g.apply((ListAppVersionResourceMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResourceMapping> resourceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionResourceMappingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resourceMappings(model.resourceMappings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourceMapping.Builder> getResourceMappings() {
            List<ResourceMapping.Builder> result = ResourceMappingListCopier.copyToBuilder(this.resourceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceMappings(Collection<ResourceMapping.BuilderImpl> resourceMappings) {
            this.resourceMappings = ResourceMappingListCopier.copyFromBuilder(resourceMappings);
        }

        @Override
        public final Builder resourceMappings(Collection<ResourceMapping> resourceMappings) {
            this.resourceMappings = ResourceMappingListCopier.copy(resourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(ResourceMapping ... resourceMappings) {
            this.resourceMappings(Arrays.asList(resourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(Consumer<ResourceMapping.Builder> ... resourceMappings) {
            this.resourceMappings(Stream.of(resourceMappings).map(c -> (ResourceMapping)((ResourceMapping.Builder)ResourceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAppVersionResourceMappingsResponse build() {
            return new ListAppVersionResourceMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppVersionResourceMappingsResponse> {
        public Builder nextToken(String var1);

        public Builder resourceMappings(Collection<ResourceMapping> var1);

        public Builder resourceMappings(ResourceMapping ... var1);

        public Builder resourceMappings(Consumer<ResourceMapping.Builder> ... var1);
    }
}

