/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentComplianceCopier;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentInvoker;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentStatus;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentSummary;
import software.amazon.awssdk.services.resiliencehub.model.ComplianceStatus;
import software.amazon.awssdk.services.resiliencehub.model.Cost;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionCompliance;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.DriftStatus;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyPolicy;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyScore;
import software.amazon.awssdk.services.resiliencehub.model.ResourceErrorsDetails;
import software.amazon.awssdk.services.resiliencehub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppAssessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppAssessment> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(AppAssessment.getter(AppAssessment::appArn)).setter(AppAssessment.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(AppAssessment.getter(AppAssessment::appVersion)).setter(AppAssessment.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentArn").getter(AppAssessment.getter(AppAssessment::assessmentArn)).setter(AppAssessment.setter(Builder::assessmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentName").getter(AppAssessment.getter(AppAssessment::assessmentName)).setter(AppAssessment.setter(Builder::assessmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()}).build();
    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentStatus").getter(AppAssessment.getter(AppAssessment::assessmentStatusAsString)).setter(AppAssessment.setter(Builder::assessmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentStatus").build()}).build();
    private static final SdkField<Map<String, DisruptionCompliance>> COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("compliance").getter(AppAssessment.getter(AppAssessment::complianceAsStrings)).setter(AppAssessment.setter(Builder::complianceWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliance").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisruptionCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceStatus").getter(AppAssessment.getter(AppAssessment::complianceStatusAsString)).setter(AppAssessment.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()}).build();
    private static final SdkField<Cost> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cost").getter(AppAssessment.getter(AppAssessment::cost)).setter(AppAssessment.setter(Builder::cost)).constructor(Cost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("driftStatus").getter(AppAssessment.getter(AppAssessment::driftStatusAsString)).setter(AppAssessment.setter(Builder::driftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AppAssessment.getter(AppAssessment::endTime)).setter(AppAssessment.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> INVOKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invoker").getter(AppAssessment.getter(AppAssessment::invokerAsString)).setter(AppAssessment.setter(Builder::invoker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invoker").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AppAssessment.getter(AppAssessment::message)).setter(AppAssessment.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<ResiliencyPolicy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policy").getter(AppAssessment.getter(AppAssessment::policy)).setter(AppAssessment.setter(Builder::policy)).constructor(ResiliencyPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<ResiliencyScore> RESILIENCY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resiliencyScore").getter(AppAssessment.getter(AppAssessment::resiliencyScore)).setter(AppAssessment.setter(Builder::resiliencyScore)).constructor(ResiliencyScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()}).build();
    private static final SdkField<ResourceErrorsDetails> RESOURCE_ERRORS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceErrorsDetails").getter(AppAssessment.getter(AppAssessment::resourceErrorsDetails)).setter(AppAssessment.setter(Builder::resourceErrorsDetails)).constructor(ResourceErrorsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceErrorsDetails").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AppAssessment.getter(AppAssessment::startTime)).setter(AppAssessment.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<AssessmentSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summary").getter(AppAssessment.getter(AppAssessment::summary)).setter(AppAssessment.setter(Builder::summary)).constructor(AssessmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AppAssessment.getter(AppAssessment::tags)).setter(AppAssessment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(AppAssessment.getter(AppAssessment::versionName)).setter(AppAssessment.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, ASSESSMENT_ARN_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_STATUS_FIELD, COMPLIANCE_FIELD, COMPLIANCE_STATUS_FIELD, COST_FIELD, DRIFT_STATUS_FIELD, END_TIME_FIELD, INVOKER_FIELD, MESSAGE_FIELD, POLICY_FIELD, RESILIENCY_SCORE_FIELD, RESOURCE_ERRORS_DETAILS_FIELD, START_TIME_FIELD, SUMMARY_FIELD, TAGS_FIELD, VERSION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppAssessment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appArn;
    private final String appVersion;
    private final String assessmentArn;
    private final String assessmentName;
    private final String assessmentStatus;
    private final Map<String, DisruptionCompliance> compliance;
    private final String complianceStatus;
    private final Cost cost;
    private final String driftStatus;
    private final Instant endTime;
    private final String invoker;
    private final String message;
    private final ResiliencyPolicy policy;
    private final ResiliencyScore resiliencyScore;
    private final ResourceErrorsDetails resourceErrorsDetails;
    private final Instant startTime;
    private final AssessmentSummary summary;
    private final Map<String, String> tags;
    private final String versionName;

    private AppAssessment(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.assessmentArn = builder.assessmentArn;
        this.assessmentName = builder.assessmentName;
        this.assessmentStatus = builder.assessmentStatus;
        this.compliance = builder.compliance;
        this.complianceStatus = builder.complianceStatus;
        this.cost = builder.cost;
        this.driftStatus = builder.driftStatus;
        this.endTime = builder.endTime;
        this.invoker = builder.invoker;
        this.message = builder.message;
        this.policy = builder.policy;
        this.resiliencyScore = builder.resiliencyScore;
        this.resourceErrorsDetails = builder.resourceErrorsDetails;
        this.startTime = builder.startTime;
        this.summary = builder.summary;
        this.tags = builder.tags;
        this.versionName = builder.versionName;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final String assessmentArn() {
        return this.assessmentArn;
    }

    public final String assessmentName() {
        return this.assessmentName;
    }

    public final AssessmentStatus assessmentStatus() {
        return AssessmentStatus.fromValue(this.assessmentStatus);
    }

    public final String assessmentStatusAsString() {
        return this.assessmentStatus;
    }

    public final Map<DisruptionType, DisruptionCompliance> compliance() {
        return AssessmentComplianceCopier.copyStringToEnum(this.compliance);
    }

    public final boolean hasCompliance() {
        return this.compliance != null && !(this.compliance instanceof SdkAutoConstructMap);
    }

    public final Map<String, DisruptionCompliance> complianceAsStrings() {
        return this.compliance;
    }

    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final Cost cost() {
        return this.cost;
    }

    public final DriftStatus driftStatus() {
        return DriftStatus.fromValue(this.driftStatus);
    }

    public final String driftStatusAsString() {
        return this.driftStatus;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final AssessmentInvoker invoker() {
        return AssessmentInvoker.fromValue(this.invoker);
    }

    public final String invokerAsString() {
        return this.invoker;
    }

    public final String message() {
        return this.message;
    }

    public final ResiliencyPolicy policy() {
        return this.policy;
    }

    public final ResiliencyScore resiliencyScore() {
        return this.resiliencyScore;
    }

    public final ResourceErrorsDetails resourceErrorsDetails() {
        return this.resourceErrorsDetails;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final AssessmentSummary summary() {
        return this.summary;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String versionName() {
        return this.versionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompliance() ? this.complianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceErrorsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppAssessment)) {
            return false;
        }
        AppAssessment other = (AppAssessment)obj;
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.assessmentArn(), other.assessmentArn()) && Objects.equals(this.assessmentName(), other.assessmentName()) && Objects.equals(this.assessmentStatusAsString(), other.assessmentStatusAsString()) && this.hasCompliance() == other.hasCompliance() && Objects.equals(this.complianceAsStrings(), other.complianceAsStrings()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.cost(), other.cost()) && Objects.equals(this.driftStatusAsString(), other.driftStatusAsString()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.invokerAsString(), other.invokerAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.resiliencyScore(), other.resiliencyScore()) && Objects.equals(this.resourceErrorsDetails(), other.resourceErrorsDetails()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.summary(), other.summary()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.versionName(), other.versionName());
    }

    public final String toString() {
        return ToString.builder((String)"AppAssessment").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("AssessmentArn", (Object)this.assessmentArn()).add("AssessmentName", (Object)this.assessmentName()).add("AssessmentStatus", (Object)this.assessmentStatusAsString()).add("Compliance", this.hasCompliance() ? this.complianceAsStrings() : null).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("Cost", (Object)this.cost()).add("DriftStatus", (Object)this.driftStatusAsString()).add("EndTime", (Object)this.endTime()).add("Invoker", (Object)this.invokerAsString()).add("Message", (Object)this.message()).add("Policy", (Object)this.policy()).add("ResiliencyScore", (Object)this.resiliencyScore()).add("ResourceErrorsDetails", (Object)this.resourceErrorsDetails()).add("StartTime", (Object)this.startTime()).add("Summary", (Object)this.summary()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("VersionName", (Object)this.versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "assessmentArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentArn()));
            }
            case "assessmentName": {
                return Optional.ofNullable(clazz.cast(this.assessmentName()));
            }
            case "assessmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assessmentStatusAsString()));
            }
            case "compliance": {
                return Optional.ofNullable(clazz.cast(this.complianceAsStrings()));
            }
            case "complianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
            case "driftStatus": {
                return Optional.ofNullable(clazz.cast(this.driftStatusAsString()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "invoker": {
                return Optional.ofNullable(clazz.cast(this.invokerAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "resiliencyScore": {
                return Optional.ofNullable(clazz.cast(this.resiliencyScore()));
            }
            case "resourceErrorsDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceErrorsDetails()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("assessmentArn", ASSESSMENT_ARN_FIELD);
        map.put("assessmentName", ASSESSMENT_NAME_FIELD);
        map.put("assessmentStatus", ASSESSMENT_STATUS_FIELD);
        map.put("compliance", COMPLIANCE_FIELD);
        map.put("complianceStatus", COMPLIANCE_STATUS_FIELD);
        map.put("cost", COST_FIELD);
        map.put("driftStatus", DRIFT_STATUS_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("invoker", INVOKER_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("resiliencyScore", RESILIENCY_SCORE_FIELD);
        map.put("resourceErrorsDetails", RESOURCE_ERRORS_DETAILS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("summary", SUMMARY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppAssessment, T> g) {
        return obj -> g.apply((AppAssessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private String assessmentArn;
        private String assessmentName;
        private String assessmentStatus;
        private Map<String, DisruptionCompliance> compliance = DefaultSdkAutoConstructMap.getInstance();
        private String complianceStatus;
        private Cost cost;
        private String driftStatus;
        private Instant endTime;
        private String invoker;
        private String message;
        private ResiliencyPolicy policy;
        private ResiliencyScore resiliencyScore;
        private ResourceErrorsDetails resourceErrorsDetails;
        private Instant startTime;
        private AssessmentSummary summary;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppAssessment model) {
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.assessmentArn(model.assessmentArn);
            this.assessmentName(model.assessmentName);
            this.assessmentStatus(model.assessmentStatus);
            this.complianceWithStrings(model.compliance);
            this.complianceStatus(model.complianceStatus);
            this.cost(model.cost);
            this.driftStatus(model.driftStatus);
            this.endTime(model.endTime);
            this.invoker(model.invoker);
            this.message(model.message);
            this.policy(model.policy);
            this.resiliencyScore(model.resiliencyScore);
            this.resourceErrorsDetails(model.resourceErrorsDetails);
            this.startTime(model.startTime);
            this.summary(model.summary);
            this.tags(model.tags);
            this.versionName(model.versionName);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getAssessmentArn() {
            return this.assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getAssessmentName() {
            return this.assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentStatus() {
            return this.assessmentStatus;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        @Override
        public final Builder assessmentStatus(AssessmentStatus assessmentStatus) {
            this.assessmentStatus(assessmentStatus == null ? null : assessmentStatus.toString());
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getCompliance() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.compliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompliance(Map<String, DisruptionCompliance.BuilderImpl> compliance) {
            this.compliance = AssessmentComplianceCopier.copyFromBuilder(compliance);
        }

        @Override
        public final Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copy(compliance);
            return this;
        }

        @Override
        public final Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copyEnumToString(compliance);
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Cost.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final String getDriftStatus() {
            return this.driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(DriftStatus driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getInvoker() {
            return this.invoker;
        }

        public final void setInvoker(String invoker) {
            this.invoker = invoker;
        }

        @Override
        public final Builder invoker(String invoker) {
            this.invoker = invoker;
            return this;
        }

        @Override
        public final Builder invoker(AssessmentInvoker invoker) {
            this.invoker(invoker == null ? null : invoker.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final ResiliencyPolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        public final void setPolicy(ResiliencyPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(ResiliencyPolicy policy) {
            this.policy = policy;
            return this;
        }

        public final ResiliencyScore.Builder getResiliencyScore() {
            return this.resiliencyScore != null ? this.resiliencyScore.toBuilder() : null;
        }

        public final void setResiliencyScore(ResiliencyScore.BuilderImpl resiliencyScore) {
            this.resiliencyScore = resiliencyScore != null ? resiliencyScore.build() : null;
        }

        @Override
        public final Builder resiliencyScore(ResiliencyScore resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final ResourceErrorsDetails.Builder getResourceErrorsDetails() {
            return this.resourceErrorsDetails != null ? this.resourceErrorsDetails.toBuilder() : null;
        }

        public final void setResourceErrorsDetails(ResourceErrorsDetails.BuilderImpl resourceErrorsDetails) {
            this.resourceErrorsDetails = resourceErrorsDetails != null ? resourceErrorsDetails.build() : null;
        }

        @Override
        public final Builder resourceErrorsDetails(ResourceErrorsDetails resourceErrorsDetails) {
            this.resourceErrorsDetails = resourceErrorsDetails;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final AssessmentSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(AssessmentSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(AssessmentSummary summary) {
            this.summary = summary;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public AppAssessment build() {
            return new AppAssessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppAssessment> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder assessmentArn(String var1);

        public Builder assessmentName(String var1);

        public Builder assessmentStatus(String var1);

        public Builder assessmentStatus(AssessmentStatus var1);

        public Builder complianceWithStrings(Map<String, DisruptionCompliance> var1);

        public Builder compliance(Map<DisruptionType, DisruptionCompliance> var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(ComplianceStatus var1);

        public Builder cost(Cost var1);

        default public Builder cost(Consumer<Cost.Builder> cost) {
            return this.cost((Cost)((Cost.Builder)Cost.builder().applyMutation(cost)).build());
        }

        public Builder driftStatus(String var1);

        public Builder driftStatus(DriftStatus var1);

        public Builder endTime(Instant var1);

        public Builder invoker(String var1);

        public Builder invoker(AssessmentInvoker var1);

        public Builder message(String var1);

        public Builder policy(ResiliencyPolicy var1);

        default public Builder policy(Consumer<ResiliencyPolicy.Builder> policy) {
            return this.policy((ResiliencyPolicy)((ResiliencyPolicy.Builder)ResiliencyPolicy.builder().applyMutation(policy)).build());
        }

        public Builder resiliencyScore(ResiliencyScore var1);

        default public Builder resiliencyScore(Consumer<ResiliencyScore.Builder> resiliencyScore) {
            return this.resiliencyScore((ResiliencyScore)((ResiliencyScore.Builder)ResiliencyScore.builder().applyMutation(resiliencyScore)).build());
        }

        public Builder resourceErrorsDetails(ResourceErrorsDetails var1);

        default public Builder resourceErrorsDetails(Consumer<ResourceErrorsDetails.Builder> resourceErrorsDetails) {
            return this.resourceErrorsDetails((ResourceErrorsDetails)((ResourceErrorsDetails.Builder)ResourceErrorsDetails.builder().applyMutation(resourceErrorsDetails)).build());
        }

        public Builder startTime(Instant var1);

        public Builder summary(AssessmentSummary var1);

        default public Builder summary(Consumer<AssessmentSummary.Builder> summary) {
            return this.summary((AssessmentSummary)((AssessmentSummary.Builder)AssessmentSummary.builder().applyMutation(summary)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder versionName(String var1);
    }
}

