/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.DataLocationConstraint;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionPolicyCopier;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.EstimatedCostTier;
import software.amazon.awssdk.services.resiliencehub.model.FailurePolicy;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyPolicyTier;
import software.amazon.awssdk.services.resiliencehub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResiliencyPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResiliencyPolicy> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ResiliencyPolicy.getter(ResiliencyPolicy::creationTime)).setter(ResiliencyPolicy.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DATA_LOCATION_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataLocationConstraint").getter(ResiliencyPolicy.getter(ResiliencyPolicy::dataLocationConstraintAsString)).setter(ResiliencyPolicy.setter(Builder::dataLocationConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocationConstraint").build()}).build();
    private static final SdkField<String> ESTIMATED_COST_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("estimatedCostTier").getter(ResiliencyPolicy.getter(ResiliencyPolicy::estimatedCostTierAsString)).setter(ResiliencyPolicy.setter(Builder::estimatedCostTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCostTier").build()}).build();
    private static final SdkField<Map<String, FailurePolicy>> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("policy").getter(ResiliencyPolicy.getter(ResiliencyPolicy::policyAsStrings)).setter(ResiliencyPolicy.setter(Builder::policyWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailurePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(ResiliencyPolicy.getter(ResiliencyPolicy::policyArn)).setter(ResiliencyPolicy.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> POLICY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDescription").getter(ResiliencyPolicy.getter(ResiliencyPolicy::policyDescription)).setter(ResiliencyPolicy.setter(Builder::policyDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDescription").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(ResiliencyPolicy.getter(ResiliencyPolicy::policyName)).setter(ResiliencyPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ResiliencyPolicy.getter(ResiliencyPolicy::tags)).setter(ResiliencyPolicy.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(ResiliencyPolicy.getter(ResiliencyPolicy::tierAsString)).setter(ResiliencyPolicy.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, DATA_LOCATION_CONSTRAINT_FIELD, ESTIMATED_COST_TIER_FIELD, POLICY_FIELD, POLICY_ARN_FIELD, POLICY_DESCRIPTION_FIELD, POLICY_NAME_FIELD, TAGS_FIELD, TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResiliencyPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String dataLocationConstraint;
    private final String estimatedCostTier;
    private final Map<String, FailurePolicy> policy;
    private final String policyArn;
    private final String policyDescription;
    private final String policyName;
    private final Map<String, String> tags;
    private final String tier;

    private ResiliencyPolicy(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.dataLocationConstraint = builder.dataLocationConstraint;
        this.estimatedCostTier = builder.estimatedCostTier;
        this.policy = builder.policy;
        this.policyArn = builder.policyArn;
        this.policyDescription = builder.policyDescription;
        this.policyName = builder.policyName;
        this.tags = builder.tags;
        this.tier = builder.tier;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final DataLocationConstraint dataLocationConstraint() {
        return DataLocationConstraint.fromValue(this.dataLocationConstraint);
    }

    public final String dataLocationConstraintAsString() {
        return this.dataLocationConstraint;
    }

    public final EstimatedCostTier estimatedCostTier() {
        return EstimatedCostTier.fromValue(this.estimatedCostTier);
    }

    public final String estimatedCostTierAsString() {
        return this.estimatedCostTier;
    }

    public final Map<DisruptionType, FailurePolicy> policy() {
        return DisruptionPolicyCopier.copyStringToEnum(this.policy);
    }

    public final boolean hasPolicy() {
        return this.policy != null && !(this.policy instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailurePolicy> policyAsStrings() {
        return this.policy;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String policyDescription() {
        return this.policyDescription;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ResiliencyPolicyTier tier() {
        return ResiliencyPolicyTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocationConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCostTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicy() ? this.policyAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResiliencyPolicy)) {
            return false;
        }
        ResiliencyPolicy other = (ResiliencyPolicy)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.dataLocationConstraintAsString(), other.dataLocationConstraintAsString()) && Objects.equals(this.estimatedCostTierAsString(), other.estimatedCostTierAsString()) && this.hasPolicy() == other.hasPolicy() && Objects.equals(this.policyAsStrings(), other.policyAsStrings()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyDescription(), other.policyDescription()) && Objects.equals(this.policyName(), other.policyName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tierAsString(), other.tierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResiliencyPolicy").add("CreationTime", (Object)this.creationTime()).add("DataLocationConstraint", (Object)this.dataLocationConstraintAsString()).add("EstimatedCostTier", (Object)this.estimatedCostTierAsString()).add("Policy", this.hasPolicy() ? this.policyAsStrings() : null).add("PolicyArn", (Object)this.policyArn()).add("PolicyDescription", (Object)this.policyDescription()).add("PolicyName", (Object)this.policyName()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("Tier", (Object)this.tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "dataLocationConstraint": {
                return Optional.ofNullable(clazz.cast(this.dataLocationConstraintAsString()));
            }
            case "estimatedCostTier": {
                return Optional.ofNullable(clazz.cast(this.estimatedCostTierAsString()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policyAsStrings()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "policyDescription": {
                return Optional.ofNullable(clazz.cast(this.policyDescription()));
            }
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("dataLocationConstraint", DATA_LOCATION_CONSTRAINT_FIELD);
        map.put("estimatedCostTier", ESTIMATED_COST_TIER_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("policyDescription", POLICY_DESCRIPTION_FIELD);
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("tier", TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResiliencyPolicy, T> g) {
        return obj -> g.apply((ResiliencyPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String dataLocationConstraint;
        private String estimatedCostTier;
        private Map<String, FailurePolicy> policy = DefaultSdkAutoConstructMap.getInstance();
        private String policyArn;
        private String policyDescription;
        private String policyName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResiliencyPolicy model) {
            this.creationTime(model.creationTime);
            this.dataLocationConstraint(model.dataLocationConstraint);
            this.estimatedCostTier(model.estimatedCostTier);
            this.policyWithStrings(model.policy);
            this.policyArn(model.policyArn);
            this.policyDescription(model.policyDescription);
            this.policyName(model.policyName);
            this.tags(model.tags);
            this.tier(model.tier);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDataLocationConstraint() {
            return this.dataLocationConstraint;
        }

        public final void setDataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
        }

        @Override
        public final Builder dataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
            return this;
        }

        @Override
        public final Builder dataLocationConstraint(DataLocationConstraint dataLocationConstraint) {
            this.dataLocationConstraint(dataLocationConstraint == null ? null : dataLocationConstraint.toString());
            return this;
        }

        public final String getEstimatedCostTier() {
            return this.estimatedCostTier;
        }

        public final void setEstimatedCostTier(String estimatedCostTier) {
            this.estimatedCostTier = estimatedCostTier;
        }

        @Override
        public final Builder estimatedCostTier(String estimatedCostTier) {
            this.estimatedCostTier = estimatedCostTier;
            return this;
        }

        @Override
        public final Builder estimatedCostTier(EstimatedCostTier estimatedCostTier) {
            this.estimatedCostTier(estimatedCostTier == null ? null : estimatedCostTier.toString());
            return this;
        }

        public final Map<String, FailurePolicy.Builder> getPolicy() {
            Map<String, FailurePolicy.Builder> result = DisruptionPolicyCopier.copyToBuilder(this.policy);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPolicy(Map<String, FailurePolicy.BuilderImpl> policy) {
            this.policy = DisruptionPolicyCopier.copyFromBuilder(policy);
        }

        @Override
        public final Builder policyWithStrings(Map<String, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copy(policy);
            return this;
        }

        @Override
        public final Builder policy(Map<DisruptionType, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copyEnumToString(policy);
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyDescription() {
            return this.policyDescription;
        }

        public final void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        @Override
        public final Builder policyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(ResiliencyPolicyTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public ResiliencyPolicy build() {
            return new ResiliencyPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResiliencyPolicy> {
        public Builder creationTime(Instant var1);

        public Builder dataLocationConstraint(String var1);

        public Builder dataLocationConstraint(DataLocationConstraint var1);

        public Builder estimatedCostTier(String var1);

        public Builder estimatedCostTier(EstimatedCostTier var1);

        public Builder policyWithStrings(Map<String, FailurePolicy> var1);

        public Builder policy(Map<DisruptionType, FailurePolicy> var1);

        public Builder policyArn(String var1);

        public Builder policyDescription(String var1);

        public Builder policyName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder tier(String var1);

        public Builder tier(ResiliencyPolicyTier var1);
    }
}

