/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AdditionalInfoMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppComponent> {
    private static final SdkField<Map<String, List<String>>> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalInfo").getter(AppComponent.getter(AppComponent::additionalInfo)).setter(AppComponent.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AppComponent.getter(AppComponent::id)).setter(AppComponent.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AppComponent.getter(AppComponent::name)).setter(AppComponent.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AppComponent.getter(AppComponent::type)).setter(AppComponent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_INFO_FIELD, ID_FIELD, NAME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppComponent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> additionalInfo;
    private final String id;
    private final String name;
    private final String type;

    private AppComponent(BuilderImpl builder) {
        this.additionalInfo = builder.additionalInfo;
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
    }

    public final boolean hasAdditionalInfo() {
        return this.additionalInfo != null && !(this.additionalInfo instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> additionalInfo() {
        return this.additionalInfo;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInfo() ? this.additionalInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppComponent)) {
            return false;
        }
        AppComponent other = (AppComponent)obj;
        return this.hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"AppComponent").add("AdditionalInfo", this.hasAdditionalInfo() ? this.additionalInfo() : null).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalInfo", ADDITIONAL_INFO_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppComponent, T> g) {
        return obj -> g.apply((AppComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> additionalInfo = DefaultSdkAutoConstructMap.getInstance();
        private String id;
        private String name;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AppComponent model) {
            this.additionalInfo(model.additionalInfo);
            this.id(model.id);
            this.name(model.name);
            this.type(model.type);
        }

        public final Map<String, ? extends Collection<String>> getAdditionalInfo() {
            if (this.additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public AppComponent build() {
            return new AppComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppComponent> {
        public Builder additionalInfo(Map<String, ? extends Collection<String>> var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder type(String var1);
    }
}

