/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendationRejectionReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectGroupingRecommendationEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RejectGroupingRecommendationEntry> {
    private static final SdkField<String> GROUPING_RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupingRecommendationId").getter(RejectGroupingRecommendationEntry.getter(RejectGroupingRecommendationEntry::groupingRecommendationId)).setter(RejectGroupingRecommendationEntry.setter(Builder::groupingRecommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingRecommendationId").build()}).build();
    private static final SdkField<String> REJECTION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rejectionReason").getter(RejectGroupingRecommendationEntry.getter(RejectGroupingRecommendationEntry::rejectionReasonAsString)).setter(RejectGroupingRecommendationEntry.setter(Builder::rejectionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPING_RECOMMENDATION_ID_FIELD, REJECTION_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RejectGroupingRecommendationEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupingRecommendationId;
    private final String rejectionReason;

    private RejectGroupingRecommendationEntry(BuilderImpl builder) {
        this.groupingRecommendationId = builder.groupingRecommendationId;
        this.rejectionReason = builder.rejectionReason;
    }

    public final String groupingRecommendationId() {
        return this.groupingRecommendationId;
    }

    public final GroupingRecommendationRejectionReason rejectionReason() {
        return GroupingRecommendationRejectionReason.fromValue(this.rejectionReason);
    }

    public final String rejectionReasonAsString() {
        return this.rejectionReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectGroupingRecommendationEntry)) {
            return false;
        }
        RejectGroupingRecommendationEntry other = (RejectGroupingRecommendationEntry)obj;
        return Objects.equals(this.groupingRecommendationId(), other.groupingRecommendationId()) && Objects.equals(this.rejectionReasonAsString(), other.rejectionReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RejectGroupingRecommendationEntry").add("GroupingRecommendationId", (Object)this.groupingRecommendationId()).add("RejectionReason", (Object)this.rejectionReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupingRecommendationId": {
                return Optional.ofNullable(clazz.cast(this.groupingRecommendationId()));
            }
            case "rejectionReason": {
                return Optional.ofNullable(clazz.cast(this.rejectionReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("groupingRecommendationId", GROUPING_RECOMMENDATION_ID_FIELD);
        map.put("rejectionReason", REJECTION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RejectGroupingRecommendationEntry, T> g) {
        return obj -> g.apply((RejectGroupingRecommendationEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupingRecommendationId;
        private String rejectionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectGroupingRecommendationEntry model) {
            this.groupingRecommendationId(model.groupingRecommendationId);
            this.rejectionReason(model.rejectionReason);
        }

        public final String getGroupingRecommendationId() {
            return this.groupingRecommendationId;
        }

        public final void setGroupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
        }

        @Override
        public final Builder groupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
            return this;
        }

        public final String getRejectionReason() {
            return this.rejectionReason;
        }

        public final void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @Override
        public final Builder rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        @Override
        public final Builder rejectionReason(GroupingRecommendationRejectionReason rejectionReason) {
            this.rejectionReason(rejectionReason == null ? null : rejectionReason.toString());
            return this;
        }

        public RejectGroupingRecommendationEntry build() {
            return new RejectGroupingRecommendationEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RejectGroupingRecommendationEntry> {
        public Builder groupingRecommendationId(String var1);

        public Builder rejectionReason(String var1);

        public Builder rejectionReason(GroupingRecommendationRejectionReason var1);
    }
}

