/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.LogicalResourceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceIdentifier> {
    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicalResourceId").getter(ResourceIdentifier.getter(ResourceIdentifier::logicalResourceId)).setter(ResourceIdentifier.setter(Builder::logicalResourceId)).constructor(LogicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ResourceIdentifier.getter(ResourceIdentifier::resourceType)).setter(ResourceIdentifier.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LogicalResourceId logicalResourceId;
    private final String resourceType;

    private ResourceIdentifier(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.resourceType = builder.resourceType;
    }

    public final LogicalResourceId logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceIdentifier").add("LogicalResourceId", (Object)this.logicalResourceId()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdentifier, T> g) {
        return obj -> g.apply((ResourceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LogicalResourceId logicalResourceId;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            this.logicalResourceId(model.logicalResourceId);
            this.resourceType(model.resourceType);
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return this.logicalResourceId != null ? this.logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceIdentifier> {
        public Builder logicalResourceId(LogicalResourceId var1);

        default public Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return this.logicalResourceId((LogicalResourceId)((LogicalResourceId.Builder)LogicalResourceId.builder().applyMutation(logicalResourceId)).build());
        }

        public Builder resourceType(String var1);
    }
}

