/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.GroupingAppComponent;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendationConfidenceLevel;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendationRejectionReason;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendationStatusType;
import software.amazon.awssdk.services.resiliencehub.model.GroupingResource;
import software.amazon.awssdk.services.resiliencehub.model.GroupingResourceListCopier;
import software.amazon.awssdk.services.resiliencehub.model.String255ListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupingRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupingRecommendation> {
    private static final SdkField<String> CONFIDENCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confidenceLevel").getter(GroupingRecommendation.getter(GroupingRecommendation::confidenceLevelAsString)).setter(GroupingRecommendation.setter(Builder::confidenceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceLevel").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GroupingRecommendation.getter(GroupingRecommendation::creationTime)).setter(GroupingRecommendation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<GroupingAppComponent> GROUPING_APP_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupingAppComponent").getter(GroupingRecommendation.getter(GroupingRecommendation::groupingAppComponent)).setter(GroupingRecommendation.setter(Builder::groupingAppComponent)).constructor(GroupingAppComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingAppComponent").build()}).build();
    private static final SdkField<String> GROUPING_RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupingRecommendationId").getter(GroupingRecommendation.getter(GroupingRecommendation::groupingRecommendationId)).setter(GroupingRecommendation.setter(Builder::groupingRecommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingRecommendationId").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationReasons").getter(GroupingRecommendation.getter(GroupingRecommendation::recommendationReasons)).setter(GroupingRecommendation.setter(Builder::recommendationReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REJECTION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rejectionReason").getter(GroupingRecommendation.getter(GroupingRecommendation::rejectionReasonAsString)).setter(GroupingRecommendation.setter(Builder::rejectionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionReason").build()}).build();
    private static final SdkField<List<GroupingResource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(GroupingRecommendation.getter(GroupingRecommendation::resources)).setter(GroupingRecommendation.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("score").getter(GroupingRecommendation.getter(GroupingRecommendation::score)).setter(GroupingRecommendation.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GroupingRecommendation.getter(GroupingRecommendation::statusAsString)).setter(GroupingRecommendation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_LEVEL_FIELD, CREATION_TIME_FIELD, GROUPING_APP_COMPONENT_FIELD, GROUPING_RECOMMENDATION_ID_FIELD, RECOMMENDATION_REASONS_FIELD, REJECTION_REASON_FIELD, RESOURCES_FIELD, SCORE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupingRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String confidenceLevel;
    private final Instant creationTime;
    private final GroupingAppComponent groupingAppComponent;
    private final String groupingRecommendationId;
    private final List<String> recommendationReasons;
    private final String rejectionReason;
    private final List<GroupingResource> resources;
    private final Double score;
    private final String status;

    private GroupingRecommendation(BuilderImpl builder) {
        this.confidenceLevel = builder.confidenceLevel;
        this.creationTime = builder.creationTime;
        this.groupingAppComponent = builder.groupingAppComponent;
        this.groupingRecommendationId = builder.groupingRecommendationId;
        this.recommendationReasons = builder.recommendationReasons;
        this.rejectionReason = builder.rejectionReason;
        this.resources = builder.resources;
        this.score = builder.score;
        this.status = builder.status;
    }

    public final GroupingRecommendationConfidenceLevel confidenceLevel() {
        return GroupingRecommendationConfidenceLevel.fromValue(this.confidenceLevel);
    }

    public final String confidenceLevelAsString() {
        return this.confidenceLevel;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final GroupingAppComponent groupingAppComponent() {
        return this.groupingAppComponent;
    }

    public final String groupingRecommendationId() {
        return this.groupingRecommendationId;
    }

    public final boolean hasRecommendationReasons() {
        return this.recommendationReasons != null && !(this.recommendationReasons instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationReasons() {
        return this.recommendationReasons;
    }

    public final GroupingRecommendationRejectionReason rejectionReason() {
        return GroupingRecommendationRejectionReason.fromValue(this.rejectionReason);
    }

    public final String rejectionReasonAsString() {
        return this.rejectionReason;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<GroupingResource> resources() {
        return this.resources;
    }

    public final Double score() {
        return this.score;
    }

    public final GroupingRecommendationStatusType status() {
        return GroupingRecommendationStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingAppComponent());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationReasons() ? this.recommendationReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingRecommendation)) {
            return false;
        }
        GroupingRecommendation other = (GroupingRecommendation)obj;
        return Objects.equals(this.confidenceLevelAsString(), other.confidenceLevelAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.groupingAppComponent(), other.groupingAppComponent()) && Objects.equals(this.groupingRecommendationId(), other.groupingRecommendationId()) && this.hasRecommendationReasons() == other.hasRecommendationReasons() && Objects.equals(this.recommendationReasons(), other.recommendationReasons()) && Objects.equals(this.rejectionReasonAsString(), other.rejectionReasonAsString()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GroupingRecommendation").add("ConfidenceLevel", (Object)this.confidenceLevelAsString()).add("CreationTime", (Object)this.creationTime()).add("GroupingAppComponent", (Object)this.groupingAppComponent()).add("GroupingRecommendationId", (Object)this.groupingRecommendationId()).add("RecommendationReasons", this.hasRecommendationReasons() ? this.recommendationReasons() : null).add("RejectionReason", (Object)this.rejectionReasonAsString()).add("Resources", this.hasResources() ? this.resources() : null).add("Score", (Object)this.score()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "confidenceLevel": {
                return Optional.ofNullable(clazz.cast(this.confidenceLevelAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "groupingAppComponent": {
                return Optional.ofNullable(clazz.cast(this.groupingAppComponent()));
            }
            case "groupingRecommendationId": {
                return Optional.ofNullable(clazz.cast(this.groupingRecommendationId()));
            }
            case "recommendationReasons": {
                return Optional.ofNullable(clazz.cast(this.recommendationReasons()));
            }
            case "rejectionReason": {
                return Optional.ofNullable(clazz.cast(this.rejectionReasonAsString()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("confidenceLevel", CONFIDENCE_LEVEL_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("groupingAppComponent", GROUPING_APP_COMPONENT_FIELD);
        map.put("groupingRecommendationId", GROUPING_RECOMMENDATION_ID_FIELD);
        map.put("recommendationReasons", RECOMMENDATION_REASONS_FIELD);
        map.put("rejectionReason", REJECTION_REASON_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("score", SCORE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupingRecommendation, T> g) {
        return obj -> g.apply((GroupingRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String confidenceLevel;
        private Instant creationTime;
        private GroupingAppComponent groupingAppComponent;
        private String groupingRecommendationId;
        private List<String> recommendationReasons = DefaultSdkAutoConstructList.getInstance();
        private String rejectionReason;
        private List<GroupingResource> resources = DefaultSdkAutoConstructList.getInstance();
        private Double score;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupingRecommendation model) {
            this.confidenceLevel(model.confidenceLevel);
            this.creationTime(model.creationTime);
            this.groupingAppComponent(model.groupingAppComponent);
            this.groupingRecommendationId(model.groupingRecommendationId);
            this.recommendationReasons(model.recommendationReasons);
            this.rejectionReason(model.rejectionReason);
            this.resources(model.resources);
            this.score(model.score);
            this.status(model.status);
        }

        public final String getConfidenceLevel() {
            return this.confidenceLevel;
        }

        public final void setConfidenceLevel(String confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
        }

        @Override
        public final Builder confidenceLevel(String confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
            return this;
        }

        @Override
        public final Builder confidenceLevel(GroupingRecommendationConfidenceLevel confidenceLevel) {
            this.confidenceLevel(confidenceLevel == null ? null : confidenceLevel.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final GroupingAppComponent.Builder getGroupingAppComponent() {
            return this.groupingAppComponent != null ? this.groupingAppComponent.toBuilder() : null;
        }

        public final void setGroupingAppComponent(GroupingAppComponent.BuilderImpl groupingAppComponent) {
            this.groupingAppComponent = groupingAppComponent != null ? groupingAppComponent.build() : null;
        }

        @Override
        public final Builder groupingAppComponent(GroupingAppComponent groupingAppComponent) {
            this.groupingAppComponent = groupingAppComponent;
            return this;
        }

        public final String getGroupingRecommendationId() {
            return this.groupingRecommendationId;
        }

        public final void setGroupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
        }

        @Override
        public final Builder groupingRecommendationId(String groupingRecommendationId) {
            this.groupingRecommendationId = groupingRecommendationId;
            return this;
        }

        public final Collection<String> getRecommendationReasons() {
            if (this.recommendationReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationReasons;
        }

        public final void setRecommendationReasons(Collection<String> recommendationReasons) {
            this.recommendationReasons = String255ListCopier.copy(recommendationReasons);
        }

        @Override
        public final Builder recommendationReasons(Collection<String> recommendationReasons) {
            this.recommendationReasons = String255ListCopier.copy(recommendationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationReasons(String ... recommendationReasons) {
            this.recommendationReasons(Arrays.asList(recommendationReasons));
            return this;
        }

        public final String getRejectionReason() {
            return this.rejectionReason;
        }

        public final void setRejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
        }

        @Override
        public final Builder rejectionReason(String rejectionReason) {
            this.rejectionReason = rejectionReason;
            return this;
        }

        @Override
        public final Builder rejectionReason(GroupingRecommendationRejectionReason rejectionReason) {
            this.rejectionReason(rejectionReason == null ? null : rejectionReason.toString());
            return this;
        }

        public final List<GroupingResource.Builder> getResources() {
            List<GroupingResource.Builder> result = GroupingResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<GroupingResource.BuilderImpl> resources) {
            this.resources = GroupingResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<GroupingResource> resources) {
            this.resources = GroupingResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(GroupingResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<GroupingResource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (GroupingResource)((GroupingResource.Builder)GroupingResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GroupingRecommendationStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public GroupingRecommendation build() {
            return new GroupingRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupingRecommendation> {
        public Builder confidenceLevel(String var1);

        public Builder confidenceLevel(GroupingRecommendationConfidenceLevel var1);

        public Builder creationTime(Instant var1);

        public Builder groupingAppComponent(GroupingAppComponent var1);

        default public Builder groupingAppComponent(Consumer<GroupingAppComponent.Builder> groupingAppComponent) {
            return this.groupingAppComponent((GroupingAppComponent)((GroupingAppComponent.Builder)GroupingAppComponent.builder().applyMutation(groupingAppComponent)).build());
        }

        public Builder groupingRecommendationId(String var1);

        public Builder recommendationReasons(Collection<String> var1);

        public Builder recommendationReasons(String ... var1);

        public Builder rejectionReason(String var1);

        public Builder rejectionReason(GroupingRecommendationRejectionReason var1);

        public Builder resources(Collection<GroupingResource> var1);

        public Builder resources(GroupingResource ... var1);

        public Builder resources(Consumer<GroupingResource.Builder> ... var1);

        public Builder score(Double var1);

        public Builder status(String var1);

        public Builder status(GroupingRecommendationStatusType var1);
    }
}

