/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationComplianceStatus {
    BREACHED_UNATTAINABLE("BreachedUnattainable"),
    BREACHED_CAN_MEET("BreachedCanMeet"),
    MET_CAN_IMPROVE("MetCanImprove"),
    MISSING_POLICY("MissingPolicy"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationComplianceStatus> VALUE_MAP;
    private final String value;

    private RecommendationComplianceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationComplianceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationComplianceStatus> knownValues() {
        EnumSet<RecommendationComplianceStatus> knownValues = EnumSet.allOf(RecommendationComplianceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationComplianceStatus.class, RecommendationComplianceStatus::toString);
    }
}

