/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse;

public class ListAlarmRecommendationsIterable
implements SdkIterable<ListAlarmRecommendationsResponse> {
    private final ResiliencehubClient client;
    private final ListAlarmRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAlarmRecommendationsIterable(ResiliencehubClient client, ListAlarmRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAlarmRecommendationsResponseFetcher();
    }

    public Iterator<ListAlarmRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAlarmRecommendationsResponseFetcher
    implements SyncPageFetcher<ListAlarmRecommendationsResponse> {
        private ListAlarmRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlarmRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAlarmRecommendationsResponse nextPage(ListAlarmRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListAlarmRecommendationsIterable.this.client.listAlarmRecommendations(ListAlarmRecommendationsIterable.this.firstRequest);
            }
            return ListAlarmRecommendationsIterable.this.client.listAlarmRecommendations((ListAlarmRecommendationsRequest)((Object)ListAlarmRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

