/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionAppComponentsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionAppComponentsResponse;

public class ListAppVersionAppComponentsIterable
implements SdkIterable<ListAppVersionAppComponentsResponse> {
    private final ResiliencehubClient client;
    private final ListAppVersionAppComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppVersionAppComponentsIterable(ResiliencehubClient client, ListAppVersionAppComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppVersionAppComponentsResponseFetcher();
    }

    public Iterator<ListAppVersionAppComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppVersionAppComponentsResponseFetcher
    implements SyncPageFetcher<ListAppVersionAppComponentsResponse> {
        private ListAppVersionAppComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppVersionAppComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppVersionAppComponentsResponse nextPage(ListAppVersionAppComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListAppVersionAppComponentsIterable.this.client.listAppVersionAppComponents(ListAppVersionAppComponentsIterable.this.firstRequest);
            }
            return ListAppVersionAppComponentsIterable.this.client.listAppVersionAppComponents((ListAppVersionAppComponentsRequest)((Object)ListAppVersionAppComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

