/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentComplianceCopier;
import software.amazon.awssdk.services.resiliencehub.model.DifferenceType;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionCompliance;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.DriftType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceDrift
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComplianceDrift> {
    private static final SdkField<String> ACTUAL_REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actualReferenceId").getter(ComplianceDrift.getter(ComplianceDrift::actualReferenceId)).setter(ComplianceDrift.setter(Builder::actualReferenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualReferenceId").build()}).build();
    private static final SdkField<Map<String, DisruptionCompliance>> ACTUAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("actualValue").getter(ComplianceDrift.getter(ComplianceDrift::actualValueAsStrings)).setter(ComplianceDrift.setter(Builder::actualValueWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualValue").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisruptionCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(ComplianceDrift.getter(ComplianceDrift::appId)).setter(ComplianceDrift.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(ComplianceDrift.getter(ComplianceDrift::appVersion)).setter(ComplianceDrift.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<String> DIFF_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diffType").getter(ComplianceDrift.getter(ComplianceDrift::diffTypeAsString)).setter(ComplianceDrift.setter(Builder::diffType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diffType").build()}).build();
    private static final SdkField<String> DRIFT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("driftType").getter(ComplianceDrift.getter(ComplianceDrift::driftTypeAsString)).setter(ComplianceDrift.setter(Builder::driftType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftType").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(ComplianceDrift.getter(ComplianceDrift::entityId)).setter(ComplianceDrift.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(ComplianceDrift.getter(ComplianceDrift::entityType)).setter(ComplianceDrift.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()}).build();
    private static final SdkField<String> EXPECTED_REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedReferenceId").getter(ComplianceDrift.getter(ComplianceDrift::expectedReferenceId)).setter(ComplianceDrift.setter(Builder::expectedReferenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedReferenceId").build()}).build();
    private static final SdkField<Map<String, DisruptionCompliance>> EXPECTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("expectedValue").getter(ComplianceDrift.getter(ComplianceDrift::expectedValueAsStrings)).setter(ComplianceDrift.setter(Builder::expectedValueWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedValue").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisruptionCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_REFERENCE_ID_FIELD, ACTUAL_VALUE_FIELD, APP_ID_FIELD, APP_VERSION_FIELD, DIFF_TYPE_FIELD, DRIFT_TYPE_FIELD, ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, EXPECTED_REFERENCE_ID_FIELD, EXPECTED_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComplianceDrift.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actualReferenceId;
    private final Map<String, DisruptionCompliance> actualValue;
    private final String appId;
    private final String appVersion;
    private final String diffType;
    private final String driftType;
    private final String entityId;
    private final String entityType;
    private final String expectedReferenceId;
    private final Map<String, DisruptionCompliance> expectedValue;

    private ComplianceDrift(BuilderImpl builder) {
        this.actualReferenceId = builder.actualReferenceId;
        this.actualValue = builder.actualValue;
        this.appId = builder.appId;
        this.appVersion = builder.appVersion;
        this.diffType = builder.diffType;
        this.driftType = builder.driftType;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.expectedReferenceId = builder.expectedReferenceId;
        this.expectedValue = builder.expectedValue;
    }

    public final String actualReferenceId() {
        return this.actualReferenceId;
    }

    public final Map<DisruptionType, DisruptionCompliance> actualValue() {
        return AssessmentComplianceCopier.copyStringToEnum(this.actualValue);
    }

    public final boolean hasActualValue() {
        return this.actualValue != null && !(this.actualValue instanceof SdkAutoConstructMap);
    }

    public final Map<String, DisruptionCompliance> actualValueAsStrings() {
        return this.actualValue;
    }

    public final String appId() {
        return this.appId;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final DifferenceType diffType() {
        return DifferenceType.fromValue(this.diffType);
    }

    public final String diffTypeAsString() {
        return this.diffType;
    }

    public final DriftType driftType() {
        return DriftType.fromValue(this.driftType);
    }

    public final String driftTypeAsString() {
        return this.driftType;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final String expectedReferenceId() {
        return this.expectedReferenceId;
    }

    public final Map<DisruptionType, DisruptionCompliance> expectedValue() {
        return AssessmentComplianceCopier.copyStringToEnum(this.expectedValue);
    }

    public final boolean hasExpectedValue() {
        return this.expectedValue != null && !(this.expectedValue instanceof SdkAutoConstructMap);
    }

    public final Map<String, DisruptionCompliance> expectedValueAsStrings() {
        return this.expectedValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actualReferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActualValue() ? this.actualValueAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.diffTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedReferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedValue() ? this.expectedValueAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceDrift)) {
            return false;
        }
        ComplianceDrift other = (ComplianceDrift)obj;
        return Objects.equals(this.actualReferenceId(), other.actualReferenceId()) && this.hasActualValue() == other.hasActualValue() && Objects.equals(this.actualValueAsStrings(), other.actualValueAsStrings()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.diffTypeAsString(), other.diffTypeAsString()) && Objects.equals(this.driftTypeAsString(), other.driftTypeAsString()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.expectedReferenceId(), other.expectedReferenceId()) && this.hasExpectedValue() == other.hasExpectedValue() && Objects.equals(this.expectedValueAsStrings(), other.expectedValueAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ComplianceDrift").add("ActualReferenceId", (Object)this.actualReferenceId()).add("ActualValue", this.hasActualValue() ? this.actualValueAsStrings() : null).add("AppId", (Object)this.appId()).add("AppVersion", (Object)this.appVersion()).add("DiffType", (Object)this.diffTypeAsString()).add("DriftType", (Object)this.driftTypeAsString()).add("EntityId", (Object)this.entityId()).add("EntityType", (Object)this.entityType()).add("ExpectedReferenceId", (Object)this.expectedReferenceId()).add("ExpectedValue", this.hasExpectedValue() ? this.expectedValueAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actualReferenceId": {
                return Optional.ofNullable(clazz.cast(this.actualReferenceId()));
            }
            case "actualValue": {
                return Optional.ofNullable(clazz.cast(this.actualValueAsStrings()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "diffType": {
                return Optional.ofNullable(clazz.cast(this.diffTypeAsString()));
            }
            case "driftType": {
                return Optional.ofNullable(clazz.cast(this.driftTypeAsString()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "expectedReferenceId": {
                return Optional.ofNullable(clazz.cast(this.expectedReferenceId()));
            }
            case "expectedValue": {
                return Optional.ofNullable(clazz.cast(this.expectedValueAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actualReferenceId", ACTUAL_REFERENCE_ID_FIELD);
        map.put("actualValue", ACTUAL_VALUE_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("diffType", DIFF_TYPE_FIELD);
        map.put("driftType", DRIFT_TYPE_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("expectedReferenceId", EXPECTED_REFERENCE_ID_FIELD);
        map.put("expectedValue", EXPECTED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComplianceDrift, T> g) {
        return obj -> g.apply((ComplianceDrift)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actualReferenceId;
        private Map<String, DisruptionCompliance> actualValue = DefaultSdkAutoConstructMap.getInstance();
        private String appId;
        private String appVersion;
        private String diffType;
        private String driftType;
        private String entityId;
        private String entityType;
        private String expectedReferenceId;
        private Map<String, DisruptionCompliance> expectedValue = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceDrift model) {
            this.actualReferenceId(model.actualReferenceId);
            this.actualValueWithStrings(model.actualValue);
            this.appId(model.appId);
            this.appVersion(model.appVersion);
            this.diffType(model.diffType);
            this.driftType(model.driftType);
            this.entityId(model.entityId);
            this.entityType(model.entityType);
            this.expectedReferenceId(model.expectedReferenceId);
            this.expectedValueWithStrings(model.expectedValue);
        }

        public final String getActualReferenceId() {
            return this.actualReferenceId;
        }

        public final void setActualReferenceId(String actualReferenceId) {
            this.actualReferenceId = actualReferenceId;
        }

        @Override
        public final Builder actualReferenceId(String actualReferenceId) {
            this.actualReferenceId = actualReferenceId;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getActualValue() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.actualValue);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActualValue(Map<String, DisruptionCompliance.BuilderImpl> actualValue) {
            this.actualValue = AssessmentComplianceCopier.copyFromBuilder(actualValue);
        }

        @Override
        public final Builder actualValueWithStrings(Map<String, DisruptionCompliance> actualValue) {
            this.actualValue = AssessmentComplianceCopier.copy(actualValue);
            return this;
        }

        @Override
        public final Builder actualValue(Map<DisruptionType, DisruptionCompliance> actualValue) {
            this.actualValue = AssessmentComplianceCopier.copyEnumToString(actualValue);
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getDiffType() {
            return this.diffType;
        }

        public final void setDiffType(String diffType) {
            this.diffType = diffType;
        }

        @Override
        public final Builder diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        @Override
        public final Builder diffType(DifferenceType diffType) {
            this.diffType(diffType == null ? null : diffType.toString());
            return this;
        }

        public final String getDriftType() {
            return this.driftType;
        }

        public final void setDriftType(String driftType) {
            this.driftType = driftType;
        }

        @Override
        public final Builder driftType(String driftType) {
            this.driftType = driftType;
            return this;
        }

        @Override
        public final Builder driftType(DriftType driftType) {
            this.driftType(driftType == null ? null : driftType.toString());
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getExpectedReferenceId() {
            return this.expectedReferenceId;
        }

        public final void setExpectedReferenceId(String expectedReferenceId) {
            this.expectedReferenceId = expectedReferenceId;
        }

        @Override
        public final Builder expectedReferenceId(String expectedReferenceId) {
            this.expectedReferenceId = expectedReferenceId;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getExpectedValue() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.expectedValue);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExpectedValue(Map<String, DisruptionCompliance.BuilderImpl> expectedValue) {
            this.expectedValue = AssessmentComplianceCopier.copyFromBuilder(expectedValue);
        }

        @Override
        public final Builder expectedValueWithStrings(Map<String, DisruptionCompliance> expectedValue) {
            this.expectedValue = AssessmentComplianceCopier.copy(expectedValue);
            return this;
        }

        @Override
        public final Builder expectedValue(Map<DisruptionType, DisruptionCompliance> expectedValue) {
            this.expectedValue = AssessmentComplianceCopier.copyEnumToString(expectedValue);
            return this;
        }

        public ComplianceDrift build() {
            return new ComplianceDrift(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComplianceDrift> {
        public Builder actualReferenceId(String var1);

        public Builder actualValueWithStrings(Map<String, DisruptionCompliance> var1);

        public Builder actualValue(Map<DisruptionType, DisruptionCompliance> var1);

        public Builder appId(String var1);

        public Builder appVersion(String var1);

        public Builder diffType(String var1);

        public Builder diffType(DifferenceType var1);

        public Builder driftType(String var1);

        public Builder driftType(DriftType var1);

        public Builder entityId(String var1);

        public Builder entityType(String var1);

        public Builder expectedReferenceId(String var1);

        public Builder expectedValueWithStrings(Map<String, DisruptionCompliance> var1);

        public Builder expectedValue(Map<DisruptionType, DisruptionCompliance> var1);
    }
}

