/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppDriftStatusType {
    NOT_CHECKED("NotChecked"),
    NOT_DETECTED("NotDetected"),
    DETECTED("Detected"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppDriftStatusType> VALUE_MAP;
    private final String value;

    private AppDriftStatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppDriftStatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppDriftStatusType> knownValues() {
        EnumSet<AppDriftStatusType> knownValues = EnumSet.allOf(AppDriftStatusType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppDriftStatusType.class, AppDriftStatusType::toString);
    }
}

