/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ExcludeRecommendationReason;
import software.amazon.awssdk.services.resiliencehub.model.UpdateRecommendationStatusItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecommendationStatusRequestEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateRecommendationStatusRequestEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(UpdateRecommendationStatusRequestEntry.getter(UpdateRecommendationStatusRequestEntry::entryId)).setter(UpdateRecommendationStatusRequestEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<String> EXCLUDE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("excludeReason").getter(UpdateRecommendationStatusRequestEntry.getter(UpdateRecommendationStatusRequestEntry::excludeReasonAsString)).setter(UpdateRecommendationStatusRequestEntry.setter(Builder::excludeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeReason").build()}).build();
    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("excluded").getter(UpdateRecommendationStatusRequestEntry.getter(UpdateRecommendationStatusRequestEntry::excluded)).setter(UpdateRecommendationStatusRequestEntry.setter(Builder::excluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()}).build();
    private static final SdkField<UpdateRecommendationStatusItem> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("item").getter(UpdateRecommendationStatusRequestEntry.getter(UpdateRecommendationStatusRequestEntry::item)).setter(UpdateRecommendationStatusRequestEntry.setter(Builder::item)).constructor(UpdateRecommendationStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(UpdateRecommendationStatusRequestEntry.getter(UpdateRecommendationStatusRequestEntry::referenceId)).setter(UpdateRecommendationStatusRequestEntry.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, EXCLUDE_REASON_FIELD, EXCLUDED_FIELD, ITEM_FIELD, REFERENCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRecommendationStatusRequestEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final String excludeReason;
    private final Boolean excluded;
    private final UpdateRecommendationStatusItem item;
    private final String referenceId;

    private UpdateRecommendationStatusRequestEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.excludeReason = builder.excludeReason;
        this.excluded = builder.excluded;
        this.item = builder.item;
        this.referenceId = builder.referenceId;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final ExcludeRecommendationReason excludeReason() {
        return ExcludeRecommendationReason.fromValue(this.excludeReason);
    }

    public final String excludeReasonAsString() {
        return this.excludeReason;
    }

    public final Boolean excluded() {
        return this.excluded;
    }

    public final UpdateRecommendationStatusItem item() {
        return this.item;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.excluded());
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommendationStatusRequestEntry)) {
            return false;
        }
        UpdateRecommendationStatusRequestEntry other = (UpdateRecommendationStatusRequestEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && Objects.equals(this.excludeReasonAsString(), other.excludeReasonAsString()) && Objects.equals(this.excluded(), other.excluded()) && Objects.equals(this.item(), other.item()) && Objects.equals(this.referenceId(), other.referenceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecommendationStatusRequestEntry").add("EntryId", (Object)this.entryId()).add("ExcludeReason", (Object)this.excludeReasonAsString()).add("Excluded", (Object)this.excluded()).add("Item", (Object)this.item()).add("ReferenceId", (Object)this.referenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "excludeReason": {
                return Optional.ofNullable(clazz.cast(this.excludeReasonAsString()));
            }
            case "excluded": {
                return Optional.ofNullable(clazz.cast(this.excluded()));
            }
            case "item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("excludeReason", EXCLUDE_REASON_FIELD);
        map.put("excluded", EXCLUDED_FIELD);
        map.put("item", ITEM_FIELD);
        map.put("referenceId", REFERENCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommendationStatusRequestEntry, T> g) {
        return obj -> g.apply((UpdateRecommendationStatusRequestEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private String excludeReason;
        private Boolean excluded;
        private UpdateRecommendationStatusItem item;
        private String referenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommendationStatusRequestEntry model) {
            this.entryId(model.entryId);
            this.excludeReason(model.excludeReason);
            this.excluded(model.excluded);
            this.item(model.item);
            this.referenceId(model.referenceId);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getExcludeReason() {
            return this.excludeReason;
        }

        public final void setExcludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
        }

        @Override
        public final Builder excludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
            return this;
        }

        @Override
        public final Builder excludeReason(ExcludeRecommendationReason excludeReason) {
            this.excludeReason(excludeReason == null ? null : excludeReason.toString());
            return this;
        }

        public final Boolean getExcluded() {
            return this.excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final UpdateRecommendationStatusItem.Builder getItem() {
            return this.item != null ? this.item.toBuilder() : null;
        }

        public final void setItem(UpdateRecommendationStatusItem.BuilderImpl item) {
            this.item = item != null ? item.build() : null;
        }

        @Override
        public final Builder item(UpdateRecommendationStatusItem item) {
            this.item = item;
            return this;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public UpdateRecommendationStatusRequestEntry build() {
            return new UpdateRecommendationStatusRequestEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateRecommendationStatusRequestEntry> {
        public Builder entryId(String var1);

        public Builder excludeReason(String var1);

        public Builder excludeReason(ExcludeRecommendationReason var1);

        public Builder excluded(Boolean var1);

        public Builder item(UpdateRecommendationStatusItem var1);

        default public Builder item(Consumer<UpdateRecommendationStatusItem.Builder> item) {
            return this.item((UpdateRecommendationStatusItem)((UpdateRecommendationStatusItem.Builder)UpdateRecommendationStatusItem.builder().applyMutation(item)).build());
        }

        public Builder referenceId(String var1);
    }
}

