/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ExcludeRecommendationReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationItem> {
    private static final SdkField<Boolean> ALREADY_IMPLEMENTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("alreadyImplemented").getter(RecommendationItem.getter(RecommendationItem::alreadyImplemented)).setter(RecommendationItem.setter(Builder::alreadyImplemented)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alreadyImplemented").build()}).build();
    private static final SdkField<String> EXCLUDE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("excludeReason").getter(RecommendationItem.getter(RecommendationItem::excludeReasonAsString)).setter(RecommendationItem.setter(Builder::excludeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeReason").build()}).build();
    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("excluded").getter(RecommendationItem.getter(RecommendationItem::excluded)).setter(RecommendationItem.setter(Builder::excluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(RecommendationItem.getter(RecommendationItem::resourceId)).setter(RecommendationItem.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetAccountId").getter(RecommendationItem.getter(RecommendationItem::targetAccountId)).setter(RecommendationItem.setter(Builder::targetAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountId").build()}).build();
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetRegion").getter(RecommendationItem.getter(RecommendationItem::targetRegion)).setter(RecommendationItem.setter(Builder::targetRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALREADY_IMPLEMENTED_FIELD, EXCLUDE_REASON_FIELD, EXCLUDED_FIELD, RESOURCE_ID_FIELD, TARGET_ACCOUNT_ID_FIELD, TARGET_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommendationItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean alreadyImplemented;
    private final String excludeReason;
    private final Boolean excluded;
    private final String resourceId;
    private final String targetAccountId;
    private final String targetRegion;

    private RecommendationItem(BuilderImpl builder) {
        this.alreadyImplemented = builder.alreadyImplemented;
        this.excludeReason = builder.excludeReason;
        this.excluded = builder.excluded;
        this.resourceId = builder.resourceId;
        this.targetAccountId = builder.targetAccountId;
        this.targetRegion = builder.targetRegion;
    }

    public final Boolean alreadyImplemented() {
        return this.alreadyImplemented;
    }

    public final ExcludeRecommendationReason excludeReason() {
        return ExcludeRecommendationReason.fromValue(this.excludeReason);
    }

    public final String excludeReasonAsString() {
        return this.excludeReason;
    }

    public final Boolean excluded() {
        return this.excluded;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String targetAccountId() {
        return this.targetAccountId;
    }

    public final String targetRegion() {
        return this.targetRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alreadyImplemented());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.excluded());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationItem)) {
            return false;
        }
        RecommendationItem other = (RecommendationItem)obj;
        return Objects.equals(this.alreadyImplemented(), other.alreadyImplemented()) && Objects.equals(this.excludeReasonAsString(), other.excludeReasonAsString()) && Objects.equals(this.excluded(), other.excluded()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.targetAccountId(), other.targetAccountId()) && Objects.equals(this.targetRegion(), other.targetRegion());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationItem").add("AlreadyImplemented", (Object)this.alreadyImplemented()).add("ExcludeReason", (Object)this.excludeReasonAsString()).add("Excluded", (Object)this.excluded()).add("ResourceId", (Object)this.resourceId()).add("TargetAccountId", (Object)this.targetAccountId()).add("TargetRegion", (Object)this.targetRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alreadyImplemented": {
                return Optional.ofNullable(clazz.cast(this.alreadyImplemented()));
            }
            case "excludeReason": {
                return Optional.ofNullable(clazz.cast(this.excludeReasonAsString()));
            }
            case "excluded": {
                return Optional.ofNullable(clazz.cast(this.excluded()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "targetAccountId": {
                return Optional.ofNullable(clazz.cast(this.targetAccountId()));
            }
            case "targetRegion": {
                return Optional.ofNullable(clazz.cast(this.targetRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alreadyImplemented", ALREADY_IMPLEMENTED_FIELD);
        map.put("excludeReason", EXCLUDE_REASON_FIELD);
        map.put("excluded", EXCLUDED_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("targetAccountId", TARGET_ACCOUNT_ID_FIELD);
        map.put("targetRegion", TARGET_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationItem, T> g) {
        return obj -> g.apply((RecommendationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean alreadyImplemented;
        private String excludeReason;
        private Boolean excluded;
        private String resourceId;
        private String targetAccountId;
        private String targetRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationItem model) {
            this.alreadyImplemented(model.alreadyImplemented);
            this.excludeReason(model.excludeReason);
            this.excluded(model.excluded);
            this.resourceId(model.resourceId);
            this.targetAccountId(model.targetAccountId);
            this.targetRegion(model.targetRegion);
        }

        public final Boolean getAlreadyImplemented() {
            return this.alreadyImplemented;
        }

        public final void setAlreadyImplemented(Boolean alreadyImplemented) {
            this.alreadyImplemented = alreadyImplemented;
        }

        @Override
        public final Builder alreadyImplemented(Boolean alreadyImplemented) {
            this.alreadyImplemented = alreadyImplemented;
            return this;
        }

        public final String getExcludeReason() {
            return this.excludeReason;
        }

        public final void setExcludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
        }

        @Override
        public final Builder excludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
            return this;
        }

        @Override
        public final Builder excludeReason(ExcludeRecommendationReason excludeReason) {
            this.excludeReason(excludeReason == null ? null : excludeReason.toString());
            return this;
        }

        public final Boolean getExcluded() {
            return this.excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getTargetAccountId() {
            return this.targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        public final String getTargetRegion() {
            return this.targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public RecommendationItem build() {
            return new RecommendationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationItem> {
        public Builder alreadyImplemented(Boolean var1);

        public Builder excludeReason(String var1);

        public Builder excludeReason(ExcludeRecommendationReason var1);

        public Builder excluded(Boolean var1);

        public Builder resourceId(String var1);

        public Builder targetAccountId(String var1);

        public Builder targetRegion(String var1);
    }
}

