/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.FieldAggregationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Field
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Field> {
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregation").getter(Field.getter(Field::aggregationAsString)).setter(Field.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Field.getter(Field::name)).setter(Field.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("aggregation", AGGREGATION_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String aggregation;
    private final String name;

    private Field(BuilderImpl builder) {
        this.aggregation = builder.aggregation;
        this.name = builder.name;
    }

    public final FieldAggregationType aggregation() {
        return FieldAggregationType.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return Objects.equals(this.aggregationAsString(), other.aggregationAsString()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"Field").add("Aggregation", (Object)this.aggregationAsString()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregation;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            this.aggregation(model.aggregation);
            this.name(model.name);
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(FieldAggregationType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public Field build() {
            return new Field(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Field> {
        public Builder aggregation(String var1);

        public Builder aggregation(FieldAggregationType var1);

        public Builder name(String var1);
    }
}

