/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.UnsupportedResource;
import software.amazon.awssdk.services.resiliencehub.model.UnsupportedResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUnsupportedAppVersionResourcesResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListUnsupportedAppVersionResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUnsupportedAppVersionResourcesResponse.getter(ListUnsupportedAppVersionResourcesResponse::nextToken)).setter(ListUnsupportedAppVersionResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> RESOLUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolutionId").getter(ListUnsupportedAppVersionResourcesResponse.getter(ListUnsupportedAppVersionResourcesResponse::resolutionId)).setter(ListUnsupportedAppVersionResourcesResponse.setter(Builder::resolutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionId").build()}).build();
    private static final SdkField<List<UnsupportedResource>> UNSUPPORTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unsupportedResources").getter(ListUnsupportedAppVersionResourcesResponse.getter(ListUnsupportedAppVersionResourcesResponse::unsupportedResources)).setter(ListUnsupportedAppVersionResourcesResponse.setter(Builder::unsupportedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsupportedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsupportedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOLUTION_ID_FIELD, UNSUPPORTED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("resolutionId", RESOLUTION_ID_FIELD);
            this.put("unsupportedResources", UNSUPPORTED_RESOURCES_FIELD);
        }
    });
    private final String nextToken;
    private final String resolutionId;
    private final List<UnsupportedResource> unsupportedResources;

    private ListUnsupportedAppVersionResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resolutionId = builder.resolutionId;
        this.unsupportedResources = builder.unsupportedResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String resolutionId() {
        return this.resolutionId;
    }

    public final boolean hasUnsupportedResources() {
        return this.unsupportedResources != null && !(this.unsupportedResources instanceof SdkAutoConstructList);
    }

    public final List<UnsupportedResource> unsupportedResources() {
        return this.unsupportedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsupportedResources() ? this.unsupportedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUnsupportedAppVersionResourcesResponse)) {
            return false;
        }
        ListUnsupportedAppVersionResourcesResponse other = (ListUnsupportedAppVersionResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resolutionId(), other.resolutionId()) && this.hasUnsupportedResources() == other.hasUnsupportedResources() && Objects.equals(this.unsupportedResources(), other.unsupportedResources());
    }

    public final String toString() {
        return ToString.builder((String)"ListUnsupportedAppVersionResourcesResponse").add("NextToken", (Object)this.nextToken()).add("ResolutionId", (Object)this.resolutionId()).add("UnsupportedResources", this.hasUnsupportedResources() ? this.unsupportedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resolutionId": {
                return Optional.ofNullable(clazz.cast(this.resolutionId()));
            }
            case "unsupportedResources": {
                return Optional.ofNullable(clazz.cast(this.unsupportedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListUnsupportedAppVersionResourcesResponse, T> g) {
        return obj -> g.apply((ListUnsupportedAppVersionResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String resolutionId;
        private List<UnsupportedResource> unsupportedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUnsupportedAppVersionResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resolutionId(model.resolutionId);
            this.unsupportedResources(model.unsupportedResources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResolutionId() {
            return this.resolutionId;
        }

        public final void setResolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
        }

        @Override
        public final Builder resolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
            return this;
        }

        public final List<UnsupportedResource.Builder> getUnsupportedResources() {
            List<UnsupportedResource.Builder> result = UnsupportedResourceListCopier.copyToBuilder(this.unsupportedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsupportedResources(Collection<UnsupportedResource.BuilderImpl> unsupportedResources) {
            this.unsupportedResources = UnsupportedResourceListCopier.copyFromBuilder(unsupportedResources);
        }

        @Override
        public final Builder unsupportedResources(Collection<UnsupportedResource> unsupportedResources) {
            this.unsupportedResources = UnsupportedResourceListCopier.copy(unsupportedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsupportedResources(UnsupportedResource ... unsupportedResources) {
            this.unsupportedResources(Arrays.asList(unsupportedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsupportedResources(Consumer<UnsupportedResource.Builder> ... unsupportedResources) {
            this.unsupportedResources(Stream.of(unsupportedResources).map(c -> (UnsupportedResource)((UnsupportedResource.Builder)UnsupportedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUnsupportedAppVersionResourcesResponse build() {
            return new ListUnsupportedAppVersionResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUnsupportedAppVersionResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder resolutionId(String var1);

        public Builder unsupportedResources(Collection<UnsupportedResource> var1);

        public Builder unsupportedResources(UnsupportedResource ... var1);

        public Builder unsupportedResources(Consumer<UnsupportedResource.Builder> ... var1);
    }
}

