/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.DifferenceType;
import software.amazon.awssdk.services.resiliencehub.model.ResourceIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDrift
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDrift> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ResourceDrift.getter(ResourceDrift::appArn)).setter(ResourceDrift.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(ResourceDrift.getter(ResourceDrift::appVersion)).setter(ResourceDrift.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<String> DIFF_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diffType").getter(ResourceDrift.getter(ResourceDrift::diffTypeAsString)).setter(ResourceDrift.setter(Builder::diffType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diffType").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(ResourceDrift.getter(ResourceDrift::referenceId)).setter(ResourceDrift.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceIdentifier").getter(ResourceDrift.getter(ResourceDrift::resourceIdentifier)).setter(ResourceDrift.setter(Builder::resourceIdentifier)).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, DIFF_TYPE_FIELD, REFERENCE_ID_FIELD, RESOURCE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("appVersion", APP_VERSION_FIELD);
            this.put("diffType", DIFF_TYPE_FIELD);
            this.put("referenceId", REFERENCE_ID_FIELD);
            this.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String appArn;
    private final String appVersion;
    private final String diffType;
    private final String referenceId;
    private final ResourceIdentifier resourceIdentifier;

    private ResourceDrift(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.diffType = builder.diffType;
        this.referenceId = builder.referenceId;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final DifferenceType diffType() {
        return DifferenceType.fromValue(this.diffType);
    }

    public final String diffTypeAsString() {
        return this.diffType;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final ResourceIdentifier resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.diffTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDrift)) {
            return false;
        }
        ResourceDrift other = (ResourceDrift)obj;
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.diffTypeAsString(), other.diffTypeAsString()) && Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDrift").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("DiffType", (Object)this.diffTypeAsString()).add("ReferenceId", (Object)this.referenceId()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "diffType": {
                return Optional.ofNullable(clazz.cast(this.diffTypeAsString()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDrift, T> g) {
        return obj -> g.apply((ResourceDrift)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private String diffType;
        private String referenceId;
        private ResourceIdentifier resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDrift model) {
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.diffType(model.diffType);
            this.referenceId(model.referenceId);
            this.resourceIdentifier(model.resourceIdentifier);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getDiffType() {
            return this.diffType;
        }

        public final void setDiffType(String diffType) {
            this.diffType = diffType;
        }

        @Override
        public final Builder diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        @Override
        public final Builder diffType(DifferenceType diffType) {
            this.diffType(diffType == null ? null : diffType.toString());
            return this;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return this.resourceIdentifier != null ? this.resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public ResourceDrift build() {
            return new ResourceDrift(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDrift> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder diffType(String var1);

        public Builder diffType(DifferenceType var1);

        public Builder referenceId(String var1);

        public Builder resourceIdentifier(ResourceIdentifier var1);

        default public Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return this.resourceIdentifier((ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation(resourceIdentifier)).build());
        }
    }
}

