/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentResourceDriftsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentResourceDriftsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceDrift;

public class ListAppAssessmentResourceDriftsPublisher
implements SdkPublisher<ListAppAssessmentResourceDriftsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAppAssessmentResourceDriftsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppAssessmentResourceDriftsPublisher(ResiliencehubAsyncClient client, ListAppAssessmentResourceDriftsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppAssessmentResourceDriftsPublisher(ResiliencehubAsyncClient client, ListAppAssessmentResourceDriftsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppAssessmentResourceDriftsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppAssessmentResourceDriftsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceDrift> resourceDrifts() {
        Function<ListAppAssessmentResourceDriftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceDrifts() != null) {
                return response.resourceDrifts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAppAssessmentResourceDriftsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAppAssessmentResourceDriftsResponseFetcher
    implements AsyncPageFetcher<ListAppAssessmentResourceDriftsResponse> {
        private ListAppAssessmentResourceDriftsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppAssessmentResourceDriftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppAssessmentResourceDriftsResponse> nextPage(ListAppAssessmentResourceDriftsResponse previousPage) {
            if (previousPage == null) {
                return ListAppAssessmentResourceDriftsPublisher.this.client.listAppAssessmentResourceDrifts(ListAppAssessmentResourceDriftsPublisher.this.firstRequest);
            }
            return ListAppAssessmentResourceDriftsPublisher.this.client.listAppAssessmentResourceDrifts((ListAppAssessmentResourceDriftsRequest)((Object)ListAppAssessmentResourceDriftsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

