/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AlarmType;
import software.amazon.awssdk.services.resiliencehub.model.AppComponentNameListCopier;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationItem;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationItemListCopier;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appComponentName").getter(AlarmRecommendation.getter(AlarmRecommendation::appComponentName)).setter(AlarmRecommendation.setter(Builder::appComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()}).build();
    private static final SdkField<List<String>> APP_COMPONENT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appComponentNames").getter(AlarmRecommendation.getter(AlarmRecommendation::appComponentNames)).setter(AlarmRecommendation.setter(Builder::appComponentNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AlarmRecommendation.getter(AlarmRecommendation::description)).setter(AlarmRecommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<RecommendationItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(AlarmRecommendation.getter(AlarmRecommendation::items)).setter(AlarmRecommendation.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AlarmRecommendation.getter(AlarmRecommendation::name)).setter(AlarmRecommendation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PREREQUISITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prerequisite").getter(AlarmRecommendation.getter(AlarmRecommendation::prerequisite)).setter(AlarmRecommendation.setter(Builder::prerequisite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prerequisite").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(AlarmRecommendation.getter(AlarmRecommendation::recommendationId)).setter(AlarmRecommendation.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationStatus").getter(AlarmRecommendation.getter(AlarmRecommendation::recommendationStatusAsString)).setter(AlarmRecommendation.setter(Builder::recommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationStatus").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(AlarmRecommendation.getter(AlarmRecommendation::referenceId)).setter(AlarmRecommendation.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AlarmRecommendation.getter(AlarmRecommendation::typeAsString)).setter(AlarmRecommendation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD, APP_COMPONENT_NAMES_FIELD, DESCRIPTION_FIELD, ITEMS_FIELD, NAME_FIELD, PREREQUISITE_FIELD, RECOMMENDATION_ID_FIELD, RECOMMENDATION_STATUS_FIELD, REFERENCE_ID_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appComponentName;
    private final List<String> appComponentNames;
    private final String description;
    private final List<RecommendationItem> items;
    private final String name;
    private final String prerequisite;
    private final String recommendationId;
    private final String recommendationStatus;
    private final String referenceId;
    private final String type;

    private AlarmRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.appComponentNames = builder.appComponentNames;
        this.description = builder.description;
        this.items = builder.items;
        this.name = builder.name;
        this.prerequisite = builder.prerequisite;
        this.recommendationId = builder.recommendationId;
        this.recommendationStatus = builder.recommendationStatus;
        this.referenceId = builder.referenceId;
        this.type = builder.type;
    }

    @Deprecated
    public final String appComponentName() {
        return this.appComponentName;
    }

    public final boolean hasAppComponentNames() {
        return this.appComponentNames != null && !(this.appComponentNames instanceof SdkAutoConstructList);
    }

    public final List<String> appComponentNames() {
        return this.appComponentNames;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<RecommendationItem> items() {
        return this.items;
    }

    public final String name() {
        return this.name;
    }

    public final String prerequisite() {
        return this.prerequisite;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final RecommendationStatus recommendationStatus() {
        return RecommendationStatus.fromValue(this.recommendationStatus);
    }

    public final String recommendationStatusAsString() {
        return this.recommendationStatus;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final AlarmType type() {
        return AlarmType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppComponentNames() ? this.appComponentNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.prerequisite());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmRecommendation)) {
            return false;
        }
        AlarmRecommendation other = (AlarmRecommendation)obj;
        return Objects.equals(this.appComponentName(), other.appComponentName()) && this.hasAppComponentNames() == other.hasAppComponentNames() && Objects.equals(this.appComponentNames(), other.appComponentNames()) && Objects.equals(this.description(), other.description()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.prerequisite(), other.prerequisite()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.recommendationStatusAsString(), other.recommendationStatusAsString()) && Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmRecommendation").add("AppComponentName", (Object)this.appComponentName()).add("AppComponentNames", this.hasAppComponentNames() ? this.appComponentNames() : null).add("Description", (Object)this.description()).add("Items", this.hasItems() ? this.items() : null).add("Name", (Object)this.name()).add("Prerequisite", (Object)this.prerequisite()).add("RecommendationId", (Object)this.recommendationId()).add("RecommendationStatus", (Object)this.recommendationStatusAsString()).add("ReferenceId", (Object)this.referenceId()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponentName": {
                return Optional.ofNullable(clazz.cast(this.appComponentName()));
            }
            case "appComponentNames": {
                return Optional.ofNullable(clazz.cast(this.appComponentNames()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "prerequisite": {
                return Optional.ofNullable(clazz.cast(this.prerequisite()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "recommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.recommendationStatusAsString()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmRecommendation, T> g) {
        return obj -> g.apply((AlarmRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appComponentName;
        private List<String> appComponentNames = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<RecommendationItem> items = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String prerequisite;
        private String recommendationId;
        private String recommendationStatus;
        private String referenceId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmRecommendation model) {
            this.appComponentName(model.appComponentName);
            this.appComponentNames(model.appComponentNames);
            this.description(model.description);
            this.items(model.items);
            this.name(model.name);
            this.prerequisite(model.prerequisite);
            this.recommendationId(model.recommendationId);
            this.recommendationStatus(model.recommendationStatus);
            this.referenceId(model.referenceId);
            this.type(model.type);
        }

        @Deprecated
        public final String getAppComponentName() {
            return this.appComponentName;
        }

        @Deprecated
        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        @Deprecated
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final Collection<String> getAppComponentNames() {
            if (this.appComponentNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appComponentNames;
        }

        public final void setAppComponentNames(Collection<String> appComponentNames) {
            this.appComponentNames = AppComponentNameListCopier.copy(appComponentNames);
        }

        @Override
        public final Builder appComponentNames(Collection<String> appComponentNames) {
            this.appComponentNames = AppComponentNameListCopier.copy(appComponentNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponentNames(String ... appComponentNames) {
            this.appComponentNames(Arrays.asList(appComponentNames));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<RecommendationItem.Builder> getItems() {
            List<RecommendationItem.Builder> result = RecommendationItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<RecommendationItem.BuilderImpl> items) {
            this.items = RecommendationItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<RecommendationItem> items) {
            this.items = RecommendationItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RecommendationItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RecommendationItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (RecommendationItem)((RecommendationItem.Builder)RecommendationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPrerequisite() {
            return this.prerequisite;
        }

        public final void setPrerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
        }

        @Override
        public final Builder prerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getRecommendationStatus() {
            return this.recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AlarmType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public AlarmRecommendation build() {
            return new AlarmRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmRecommendation> {
        @Deprecated
        public Builder appComponentName(String var1);

        public Builder appComponentNames(Collection<String> var1);

        public Builder appComponentNames(String ... var1);

        public Builder description(String var1);

        public Builder items(Collection<RecommendationItem> var1);

        public Builder items(RecommendationItem ... var1);

        public Builder items(Consumer<RecommendationItem.Builder> ... var1);

        public Builder name(String var1);

        public Builder prerequisite(String var1);

        public Builder recommendationId(String var1);

        public Builder recommendationStatus(String var1);

        public Builder recommendationStatus(RecommendationStatus var1);

        public Builder referenceId(String var1);

        public Builder type(String var1);

        public Builder type(AlarmType var1);
    }
}

