/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AppAssessmentScheduleType;
import software.amazon.awssdk.services.resiliencehub.model.EventSubscription;
import software.amazon.awssdk.services.resiliencehub.model.EventSubscriptionListCopier;
import software.amazon.awssdk.services.resiliencehub.model.PermissionModel;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, CreateAppRequest> {
    private static final SdkField<String> ASSESSMENT_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentSchedule").getter(CreateAppRequest.getter(CreateAppRequest::assessmentScheduleAsString)).setter(CreateAppRequest.setter(Builder::assessmentSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSchedule").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAppRequest.getter(CreateAppRequest::clientToken)).setter(CreateAppRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAppRequest.getter(CreateAppRequest::description)).setter(CreateAppRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventSubscriptions").getter(CreateAppRequest.getter(CreateAppRequest::eventSubscriptions)).setter(CreateAppRequest.setter(Builder::eventSubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAppRequest.getter(CreateAppRequest::name)).setter(CreateAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PermissionModel> PERMISSION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("permissionModel").getter(CreateAppRequest.getter(CreateAppRequest::permissionModel)).setter(CreateAppRequest.setter(Builder::permissionModel)).constructor(PermissionModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionModel").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(CreateAppRequest.getter(CreateAppRequest::policyArn)).setter(CreateAppRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAppRequest.getter(CreateAppRequest::tags)).setter(CreateAppRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_SCHEDULE_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, EVENT_SUBSCRIPTIONS_FIELD, NAME_FIELD, PERMISSION_MODEL_FIELD, POLICY_ARN_FIELD, TAGS_FIELD));
    private final String assessmentSchedule;
    private final String clientToken;
    private final String description;
    private final List<EventSubscription> eventSubscriptions;
    private final String name;
    private final PermissionModel permissionModel;
    private final String policyArn;
    private final Map<String, String> tags;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentSchedule = builder.assessmentSchedule;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.eventSubscriptions = builder.eventSubscriptions;
        this.name = builder.name;
        this.permissionModel = builder.permissionModel;
        this.policyArn = builder.policyArn;
        this.tags = builder.tags;
    }

    public final AppAssessmentScheduleType assessmentSchedule() {
        return AppAssessmentScheduleType.fromValue(this.assessmentSchedule);
    }

    public final String assessmentScheduleAsString() {
        return this.assessmentSchedule;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEventSubscriptions() {
        return this.eventSubscriptions != null && !(this.eventSubscriptions instanceof SdkAutoConstructList);
    }

    public final List<EventSubscription> eventSubscriptions() {
        return this.eventSubscriptions;
    }

    public final String name() {
        return this.name;
    }

    public final PermissionModel permissionModel() {
        return this.permissionModel;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventSubscriptions() ? this.eventSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)((Object)obj);
        return Objects.equals(this.assessmentScheduleAsString(), other.assessmentScheduleAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && this.hasEventSubscriptions() == other.hasEventSubscriptions() && Objects.equals(this.eventSubscriptions(), other.eventSubscriptions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.permissionModel(), other.permissionModel()) && Objects.equals(this.policyArn(), other.policyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppRequest").add("AssessmentSchedule", (Object)this.assessmentScheduleAsString()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("EventSubscriptions", this.hasEventSubscriptions() ? this.eventSubscriptions() : null).add("Name", (Object)this.name()).add("PermissionModel", (Object)this.permissionModel()).add("PolicyArn", (Object)this.policyArn()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentSchedule": {
                return Optional.ofNullable(clazz.cast(this.assessmentScheduleAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "eventSubscriptions": {
                return Optional.ofNullable(clazz.cast(this.eventSubscriptions()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "permissionModel": {
                return Optional.ofNullable(clazz.cast(this.permissionModel()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String assessmentSchedule;
        private String clientToken;
        private String description;
        private List<EventSubscription> eventSubscriptions = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private PermissionModel permissionModel;
        private String policyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            this.assessmentSchedule(model.assessmentSchedule);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.eventSubscriptions(model.eventSubscriptions);
            this.name(model.name);
            this.permissionModel(model.permissionModel);
            this.policyArn(model.policyArn);
            this.tags(model.tags);
        }

        public final String getAssessmentSchedule() {
            return this.assessmentSchedule;
        }

        public final void setAssessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
        }

        @Override
        public final Builder assessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
            return this;
        }

        @Override
        public final Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
            this.assessmentSchedule(assessmentSchedule == null ? null : assessmentSchedule.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptions() {
            List<EventSubscription.Builder> result = EventSubscriptionListCopier.copyToBuilder(this.eventSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptions(Collection<EventSubscription.BuilderImpl> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copyFromBuilder(eventSubscriptions);
        }

        @Override
        public final Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copy(eventSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(EventSubscription ... eventSubscriptions) {
            this.eventSubscriptions(Arrays.asList(eventSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(Consumer<EventSubscription.Builder> ... eventSubscriptions) {
            this.eventSubscriptions(Stream.of(eventSubscriptions).map(c -> (EventSubscription)((EventSubscription.Builder)EventSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PermissionModel.Builder getPermissionModel() {
            return this.permissionModel != null ? this.permissionModel.toBuilder() : null;
        }

        public final void setPermissionModel(PermissionModel.BuilderImpl permissionModel) {
            this.permissionModel = permissionModel != null ? permissionModel.build() : null;
        }

        @Override
        public final Builder permissionModel(PermissionModel permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppRequest> {
        public Builder assessmentSchedule(String var1);

        public Builder assessmentSchedule(AppAssessmentScheduleType var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder eventSubscriptions(Collection<EventSubscription> var1);

        public Builder eventSubscriptions(EventSubscription ... var1);

        public Builder eventSubscriptions(Consumer<EventSubscription.Builder> ... var1);

        public Builder name(String var1);

        public Builder permissionModel(PermissionModel var1);

        default public Builder permissionModel(Consumer<PermissionModel.Builder> permissionModel) {
            return this.permissionModel((PermissionModel)((PermissionModel.Builder)PermissionModel.builder().applyMutation(permissionModel)).build());
        }

        public Builder policyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

