/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class AssessmentComplianceCopier {
    static Map<String, DisruptionCompliance> copy(Map<String, ? extends DisruptionCompliance> assessmentComplianceParam) {
        Map<String, DisruptionCompliance> map;
        if (assessmentComplianceParam == null || assessmentComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            assessmentComplianceParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DisruptionCompliance> copyFromBuilder(
            Map<String, ? extends DisruptionCompliance.Builder> assessmentComplianceParam) {
        Map<String, DisruptionCompliance> map;
        if (assessmentComplianceParam == null || assessmentComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            assessmentComplianceParam.forEach((key, value) -> {
                DisruptionCompliance member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DisruptionCompliance.Builder> copyToBuilder(
            Map<String, ? extends DisruptionCompliance> assessmentComplianceParam) {
        Map<String, DisruptionCompliance.Builder> map;
        if (assessmentComplianceParam == null || assessmentComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DisruptionCompliance.Builder> modifiableMap = new LinkedHashMap<>();
            assessmentComplianceParam.forEach((key, value) -> {
                DisruptionCompliance.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DisruptionCompliance> copyEnumToString(
            Map<DisruptionType, ? extends DisruptionCompliance> assessmentComplianceParam) {
        Map<String, DisruptionCompliance> map;
        if (assessmentComplianceParam == null || assessmentComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            assessmentComplianceParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DisruptionType, DisruptionCompliance> copyStringToEnum(
            Map<String, ? extends DisruptionCompliance> assessmentComplianceParam) {
        Map<DisruptionType, DisruptionCompliance> map;
        if (assessmentComplianceParam == null || assessmentComplianceParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DisruptionType, DisruptionCompliance> modifiableMap = new LinkedHashMap<>();
            assessmentComplianceParam.forEach((key, value) -> {
                DisruptionType result = DisruptionType.fromValue(key);
                if (result != DisruptionType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
